package me.Funnygatt.SkExtras.Expressions;

import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.Changer.ChangeMode;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.util.Vector;

public abstract class ExpVelocity extends SimplePropertyExpression<Entity, Vector> {

	public Vector convert(Entity[] entity) {
		for (Entity e : entity) {
			return e.getVelocity();
		}
		if (entity == null) {
			return null;
		}
		return null;
	}

	@Override
	public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
		Entity[] entity = getExpr().getAll(e);
		if(entity == null)
			return;
		Vector v = (Vector) delta[0];
		for (Entity entity1 : entity){
			if (mode == Changer.ChangeMode.SET){
				entity1.setVelocity(v);
			}
		}
	}


	@SuppressWarnings("unchecked")
	@Override
	public Class<?>[] acceptChange(final ChangeMode mode) {
		if (mode == Changer.ChangeMode.SET) //SET can be replaced with REMOVE ADD or similiar stuff.
			return CollectionUtils.array(Boolean.class); //The Class should be the TypeToGet and in this case Number.
		if (mode == Changer.ChangeMode.REMOVE)
			return CollectionUtils.array(Boolean.class);
		return null;
	}

	@Override
	public Class<? extends Vector> getReturnType() { //ReturnType is TypeToGet and in this case Number.
		return Vector.class;

	}
	@Override
	protected String getPropertyName() {
		// TODO Auto-generated method stub
		return "Velocity";
	}

}
