package me.Funnygatt.SkExtras.Effects.Disguising;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser.ParseResult;
import ch.njol.util.Kleenean;
import me.Funnygatt.SkExtras.Utils.EnumHelper;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.MiscDisguise;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

import java.util.ArrayList;

public class EffNewDisguise extends Effect{

	private Expression<Entity> entities;
	private Expression<String> type;
	private Expression<ItemType> blocktype;
	private Expression<Player> playerviewers;
	private static java.util.List<String> Viewers = new ArrayList<String>();
	boolean baby;
	boolean fallingblock;
	boolean undis;
	
	@SuppressWarnings("unchecked")
	@Override
	public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean,
			ParseResult parse) {
		this.entities  = (Expression<Entity>) exprs[0];
		this.type = (Expression<String>) exprs[1];
		this.playerviewers = (Expression<Player>) exprs[2];
		this.baby = false;
		if (i == 2){
			this.baby = true;
		}

		if (i == 3){
			this.fallingblock = true;
			this.blocktype = (Expression<ItemType>) exprs[1];
		}

		if (i == 4){
			this.undis = true;
		}
		
		return true;
	}

	@Override
	public String toString(@javax.annotation.Nullable Event arg0, boolean arg1) {
		return "disguise entities";
	}

	@Override

	protected void execute(Event event) {

		if (this.undis == true) {
			for (Entity e : (Entity[]) this.entities.getAll((Event) event)) {
				DisguiseAPI.undisguiseToAll(e);
			}
		}
		if (this.fallingblock == true) {
			ItemType t = (ItemType) this.blocktype.getSingle(event);
			for (ItemStack i : t.getAll()) {
				for (Entity e : this.entities.getAll(event)) {
					DisguiseAPI.disguiseEntity(e, new MiscDisguise(DisguiseType.FALLING_BLOCK, i.getType().getId()));
				}
			}
		}
		if (this.fallingblock == false && this.undis == false) {
			if (this.playerviewers.getAll(event).length == 0) {
				String dist = (String) this.type.getSingle(event);

				for (Entity e : (Entity[]) this.entities.getAll((Event) event)) {
					DisguiseType disguise = DisguiseType.getType(e);

					if (disguise.isMisc()) {
						DisguiseAPI.disguiseEntity(e, new MiscDisguise(DisguiseType.valueOf(EnumHelper.toBukkitEnum(dist))));
					}
					if (disguise.isMob()) {
						DisguiseAPI.disguiseEntity(e, new MobDisguise(DisguiseType.valueOf(EnumHelper.toBukkitEnum(dist)), false));
						if (this.baby == true) {
							DisguiseAPI.disguiseEntity(e, new MobDisguise(DisguiseType.valueOf(EnumHelper.toBukkitEnum(dist)), true));
						}
					}
				}
				if (this.playerviewers.getAll(event).length > 0) {
					String dis = (String) this.type.getSingle(event);
					for (Entity e : (Entity[]) this.entities.getAll((Event) event)) {
						DisguiseType disguise = DisguiseType.getType(e);
						//playerviewerstring = playerviewers.getAll(event).toString();
						if (disguise.isMisc()) {
							for (Player p : (Player[]) this.playerviewers.getAll((Event) event)) {
								DisguiseAPI.disguiseToPlayers(e, new MiscDisguise(DisguiseType.valueOf(EnumHelper.toBukkitEnum(dis))), p.toString());
							}
						}
						if (disguise.isMob()) {
							for (Player p : (Player[]) this.playerviewers.getAll((Event) event)) {
								DisguiseAPI.disguiseToPlayers(e, new MobDisguise(DisguiseType.valueOf(EnumHelper.toBukkitEnum(dis))), p.toString());
							}
						}
					}
				}
			}
		}
		
	}

}
