package me.Funnygatt.SkExtras.Effects.Disguising;

import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import me.Funnygatt.SkExtras.Utils.EnumHelper;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.MiscDisguise;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;

import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;


public class EffDisguise extends Effect{

	private Expression<Entity> entities;
	private Expression<String> type;
	public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parse) {
		this.entities  = (Expression<Entity>) exprs[0];
		this.type = (Expression<String>) exprs[1];
		return true;
	}

	@Override
	public String toString(@javax.annotation.Nullable Event arg0, boolean arg1) {
		return "disguise entities";
	}

	@Override

	protected void execute(Event event) {
		Entity[] ent = entities.getAll(event);
		String dis = this.type.getSingle(event);
		DisguiseType disguise = DisguiseType.getType(EntityType.valueOf(EnumHelper.toBukkitEnum(dis)));
		for (Entity e : ent) {
			if (disguise.isMisc()) {
				DisguiseAPI.disguiseEntity(e, new MiscDisguise(DisguiseType.valueOf(EnumHelper.toBukkitEnum(dis))));
			}
			if (disguise.isMob()) {
				DisguiseAPI.disguiseEntity(e, new MobDisguise(DisguiseType.valueOf(EnumHelper.toBukkitEnum(dis))));
			}
		}
		
	}

}
