package me.Funnygatt.SkExtras.Effects.Disguising;

import me.Funnygatt.SkExtras.Utils.EnumHelper;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.MiscDisguise;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;

import org.bukkit.entity.Entity;
import org.bukkit.event.Event;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser.ParseResult;
import ch.njol.util.Kleenean;

public class EffBabyDisguise extends Effect{

	private Expression<Entity> entities;
	private Expression<String> type;

	@SuppressWarnings("unchecked")
	@Override
	public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean,
						ParseResult parse) {
		this.entities  = (Expression<Entity>) exprs[0];
		this.type = (Expression<String>) exprs[1];

		return true;
	}

	@Override
	public String toString(@javax.annotation.Nullable Event arg0, boolean arg1) {
		return "disguise " + this.entities.toString() + " as " + this.type.toString();
	}

	@Override

	protected void execute(Event event) {

		String dist = (String)this.type.getSingle(event);

		for (Entity e : (Entity[])this.entities.getAll((Event) event)) {
			DisguiseType disguise = DisguiseType.getType(e);
			Disguise d;
			if (disguise.isMisc()){
				//DisguiseAPI.di
				DisguiseAPI.disguiseEntity(e, new MiscDisguise(DisguiseType.valueOf(EnumHelper.toBukkitEnum(dist))));
			}
			if (disguise.isMob()){
				DisguiseAPI.disguiseEntity(e, new MobDisguise(DisguiseType.valueOf(EnumHelper.toBukkitEnum(dist))));
			}
		}

	}

}
