package me.Funnygatt.SkExtras.Expressions;

import me.Funnygatt.SkExtras.Utils.FreezeManager;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.Changer.ChangeMode;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;

public class ExpIsFrozen extends SimplePropertyExpression<Player, Boolean>{
	
	@Override
	public Boolean convert(Player arg0) {
		if(arg0 == null)
            return null;
		return FreezeManager.IsFrozen(arg0);
	}
	
	@Override
	public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
		Player p = getExpr().getSingle(e); //Called to get the Target which is Player in this case.
		if(p == null)
        	 return;
		Boolean b = (Boolean) (delta[0]);
		if (mode == Changer.ChangeMode.SET){
			FreezeManager.SetFrozen(p, b);
		}
	}


	@SuppressWarnings("unchecked")
    @Override
    public Class<?>[] acceptChange(final ChangeMode mode) {
		if (mode == Changer.ChangeMode.SET) //SET can be replaced with REMOVE ADD or similiar stuff.
			return CollectionUtils.array(Boolean.class); //The Class should be the TypeToGet and in this case Number.
		if (mode == Changer.ChangeMode.REMOVE)
			return CollectionUtils.array(Boolean.class);
		return null;
	}
	
	@Override
	public Class<? extends Boolean> getReturnType() { //ReturnType is TypeToGet and in this case Number.
		return Boolean.class;
	
	}
	@Override
	protected String getPropertyName() {
		// TODO Auto-generated method stub
		return "Is Frozen";
	}

}
