package me.Funnygatt.SkExtras.Expressions;

import ch.njol.skript.classes.Changer.ChangeMode;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

/**
 * Created by Zachary on 7/14/2014.
 */
public class ExpDisplayedSuffix extends SimplePropertyExpression<Player, String> {

		@Override
		public String convert(Player arg0) {
			if(arg0 == null)
				return null;
			return me.Funnygatt.SkExtras.Utils.DisplayPreSufManager.getPlayerSuffix(arg0);
		}

		@Override
		public void change(Event e, Object[] delta, ChangeMode mode) {
			Player p = getExpr().getSingle(e); //Called to get the Target which is Player in this case.
			if(p == null)
				return;
			String b = (String) (delta[0]);
			if (mode == ChangeMode.SET){
				me.Funnygatt.SkExtras.Utils.DisplayPreSufManager.setPlayerSuffix(b, p);
			}
			if (mode == ChangeMode.RESET){
				me.Funnygatt.SkExtras.Utils.DisplayPreSufManager.setPlayerSuffix("", p);
			}
		}


		@SuppressWarnings("unchecked")
		@Override
		public Class<?>[] acceptChange(final ChangeMode mode) {
			if (mode == ChangeMode.SET) //SET can be replaced with REMOVE ADD or similiar stuff.
				return CollectionUtils.array(String.class); //The Class should be the TypeToGet and in this case Number.
			if (mode == ChangeMode.RESET)
				return CollectionUtils.array(String.class);
			return null;
		}

		@Override
		public Class<? extends String> getReturnType() { //ReturnType is TypeToGet and in this case Number.
			return String.class;

		}
		@Override
		protected String getPropertyName() {
			// TODO Auto-generated method stub
			return "Displayed Suffix";
		}

	}
