/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skemail.expressions.services;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.olyno.skemail.types.EmailService;
import org.apache.commons.lang.StringUtils;
import org.bukkit.event.Event;

@Name(value="SMTP Port of Email Service")
@Description(value={"Returns the smtp port of an email service. Can be set in a email service scope"})
@Examples(value={"make new email service:", "\tset smtp port of service to 900"})
@Since(value="1.3")
public class ExprSMTPPortOfService
extends SimplePropertyExpression<EmailService, Object> {
    public Object convert(EmailService service) {
        return service.getSmtp_port();
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE) {
            return new Class[]{Object.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (delta[0] instanceof String || delta[0] instanceof Integer && StringUtils.isNumeric((String)((String)delta[0]))) {
            block4: for (EmailService service : (EmailService[])this.getExpr().getArray(e)) {
                switch (mode) {
                    case SET: {
                        service.setSmtp_port(delta[0]);
                        continue block4;
                    }
                    case DELETE: {
                        service.setSmtp_port(null);
                        continue block4;
                    }
                }
            }
        } else {
            System.out.println("[SkEmail] A smtp port must to be an integer or a string like \"900\" or 900, and not " + delta[0]);
        }
    }

    protected String getPropertyName() {
        return "smtp address";
    }

    public Class<? extends Object> getReturnType() {
        return Object.class;
    }

    static {
        ExprSMTPPortOfService.register(ExprSMTPPortOfService.class, Object.class, (String)"smtp(-|_| )port", (String)"emailservice");
    }
}

