/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skemail.expressions.services;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.olyno.skemail.types.EmailService;
import org.bukkit.event.Event;

@Name(value="Name of Email Service")
@Description(value={"Returns the name of an email service. Can be set in a email service scope"})
@Examples(value={"make new email service:", "\tset name of service to \"My service\""})
@Since(value="1.3")
public class ExprNameOfService
extends SimplePropertyExpression<EmailService, String> {
    public String convert(EmailService service) {
        return service.getName();
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE) {
            return new Class[]{String.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        block4: for (EmailService service : (EmailService[])this.getExpr().getArray(e)) {
            switch (mode) {
                case SET: {
                    service.setName((String)delta[0]);
                    continue block4;
                }
                case DELETE: {
                    service.setName(null);
                    continue block4;
                }
            }
        }
    }

    protected String getPropertyName() {
        return "name";
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        ExprNameOfService.register(ExprNameOfService.class, String.class, (String)"name", (String)"emailservice");
    }
}

