/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skemail.expressions.services;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.olyno.skemail.types.EmailService;
import org.bukkit.event.Event;

@Name(value="IMAP Address of Email Service")
@Description(value={"Returns the imap address of an email service. Can be set in a email service scope"})
@Examples(value={"make new email service:", "\tset imap address of service to \"imap.myservice.com\""})
@Since(value="1.3")
public class ExprIMAPAddressOfService
extends SimplePropertyExpression<EmailService, String> {
    public String convert(EmailService service) {
        return service.getImap_address();
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE) {
            return new Class[]{String.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        block4: for (EmailService service : (EmailService[])this.getExpr().getArray(e)) {
            switch (mode) {
                case SET: {
                    service.setImap_address((String)delta[0]);
                    continue block4;
                }
                case DELETE: {
                    service.setImap_address(null);
                    continue block4;
                }
            }
        }
    }

    protected String getPropertyName() {
        return "imap address";
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        ExprIMAPAddressOfService.register(ExprIMAPAddressOfService.class, String.class, (String)"imap(-|_| )address", (String)"emailservice");
    }
}

