/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skemail.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.bukkit.event.Event;

@Name(value="Object of Email")
@Description(value={"Returns the object of an email. Can be set in a email scope"})
@Examples(value={"make new email:", "\tset object of email to \"Test\""})
@Since(value="1.0")
public class ExprSubjectOfEmail
extends SimplePropertyExpression<Message, String> {
    public String convert(Message email) {
        try {
            return email.getSubject();
        }
        catch (MessagingException e) {
            return null;
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE) {
            return new Class[]{String.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        try {
            block6: for (Message email : (Message[])this.getExpr().getArray(e)) {
                switch (mode) {
                    case SET: {
                        email.setSubject((String)delta[0]);
                        continue block6;
                    }
                    case DELETE: {
                        email.setSubject(null);
                        continue block6;
                    }
                }
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }

    protected String getPropertyName() {
        return "subject";
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        ExprSubjectOfEmail.register(ExprSubjectOfEmail.class, String.class, (String)"(title|subject|object)", (String)"email");
    }
}

