/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skemail.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.olyno.skemail.SkEmail;
import com.olyno.skemail.types.IAddress;
import java.util.Arrays;
import java.util.LinkedList;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.bukkit.event.Event;

@Name(value="Receiver/Recipients of Email")
@Description(value={"Returns the receivers/recipients of an email. Can be set in a email scope"})
@Examples(value={"make new email:", "\tset receiver of email to \"myfriend@gmail.com\""})
@Since(value="1.0")
public class ExprReceiversOfEmail
extends SimpleExpression<Address> {
    private Expression<Message> message;

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.message = expr[0];
        return true;
    }

    protected Address[] get(Event e) {
        try {
            Message email = (Message)this.message.getSingle(e);
            return email.getAllRecipients();
        }
        catch (MessagingException e1) {
            return null;
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.DELETE) {
            return new Class[]{Object.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Message email = (Message)this.message.getSingle(e);
        try {
            LinkedList<Address> addressesTo = new LinkedList<Address>();
            LinkedList<Address> addressesCc = new LinkedList<Address>();
            LinkedList<Address> addressesBcc = new LinkedList<Address>();
            if (email.getRecipients(Message.RecipientType.TO) != null) {
                addressesTo.addAll(Arrays.asList(email.getRecipients(Message.RecipientType.TO)));
            }
            if (email.getRecipients(Message.RecipientType.CC) != null) {
                addressesCc.addAll(Arrays.asList(email.getRecipients(Message.RecipientType.CC)));
            }
            if (email.getRecipients(Message.RecipientType.BCC) != null) {
                addressesBcc.addAll(Arrays.asList(email.getRecipients(Message.RecipientType.BCC)));
            }
            switch (mode) {
                case SET: {
                    addressesTo = new LinkedList();
                    addressesCc = new LinkedList();
                    addressesBcc = new LinkedList();
                    if (delta.length > 1) {
                        for (Object o : delta) {
                            if (o instanceof String) {
                                addressesTo.add(new InternetAddress((String)o));
                                continue;
                            }
                            if (!(o instanceof IAddress)) continue;
                            IAddress a = (IAddress)o;
                            if (a.getType() == Message.RecipientType.TO) {
                                addressesTo.add(a.getAddress());
                                continue;
                            }
                            if (a.getType() == Message.RecipientType.CC) {
                                addressesCc.add(a.getAddress());
                                continue;
                            }
                            if (a.getType() != Message.RecipientType.BCC) continue;
                            addressesBcc.add(a.getAddress());
                        }
                        email.setRecipients(Message.RecipientType.TO, addressesTo.toArray(new InternetAddress[addressesTo.size()]));
                        email.setRecipients(Message.RecipientType.CC, addressesCc.toArray(new InternetAddress[addressesCc.size()]));
                        email.setRecipients(Message.RecipientType.BCC, addressesBcc.toArray(new InternetAddress[addressesBcc.size()]));
                        break;
                    }
                    if (delta[0] instanceof String) {
                        email.setRecipient(Message.RecipientType.TO, new InternetAddress((String)delta[0]));
                        break;
                    }
                    if (delta[0] instanceof IAddress) {
                        IAddress a = (IAddress)delta[0];
                        email.setRecipient(a.getType(), a.getAddress());
                        break;
                    }
                    SkEmail.error("The type of this receiver is not a IAddress or a string, but a " + delta[0].getClass().getName());
                    break;
                }
                case ADD: {
                    for (Object o : delta) {
                        if (o instanceof String) {
                            InternetAddress address = new InternetAddress((String)o);
                            address.validate();
                            addressesTo.add(address);
                            continue;
                        }
                        if (o instanceof IAddress) {
                            IAddress a = (IAddress)o;
                            if (a.getType() == Message.RecipientType.TO) {
                                addressesTo.add(a.getAddress());
                                continue;
                            }
                            if (a.getType() == Message.RecipientType.CC) {
                                addressesCc.add(a.getAddress());
                                continue;
                            }
                            if (a.getType() != Message.RecipientType.BCC) continue;
                            addressesBcc.add(a.getAddress());
                            continue;
                        }
                        SkEmail.error("You can't add a receiver (recipient) of type " + o.getClass().getName() + " because it's not a type String or IAddress.");
                    }
                    email.setRecipients(Message.RecipientType.TO, addressesTo.toArray(new InternetAddress[addressesTo.size()]));
                    email.setRecipients(Message.RecipientType.CC, addressesCc.toArray(new InternetAddress[addressesCc.size()]));
                    email.setRecipients(Message.RecipientType.BCC, addressesBcc.toArray(new InternetAddress[addressesBcc.size()]));
                    break;
                }
                case REMOVE: {
                    for (Object o : delta) {
                        if (o instanceof String) {
                            InternetAddress address = new InternetAddress((String)o);
                            address.validate();
                            addressesTo.remove(address);
                            continue;
                        }
                        if (o instanceof IAddress) {
                            IAddress a = (IAddress)o;
                            if (a.getType() == Message.RecipientType.TO) {
                                addressesTo.remove(a.getAddress());
                                continue;
                            }
                            if (a.getType() == Message.RecipientType.CC) {
                                addressesCc.remove(a.getAddress());
                                continue;
                            }
                            if (a.getType() != Message.RecipientType.BCC) continue;
                            addressesBcc.remove(a.getAddress());
                            continue;
                        }
                        SkEmail.error("You can't add a receiver (recipient) of type " + o.getClass().getName() + " because it's not a type String or IAddress.");
                    }
                    email.setRecipients(Message.RecipientType.TO, addressesTo.toArray(new InternetAddress[addressesTo.size()]));
                    email.setRecipients(Message.RecipientType.CC, addressesCc.toArray(new InternetAddress[addressesCc.size()]));
                    email.setRecipients(Message.RecipientType.BCC, addressesBcc.toArray(new InternetAddress[addressesBcc.size()]));
                    break;
                }
                case DELETE: {
                    email.setRecipient(Message.RecipientType.TO, null);
                    break;
                }
            }
        }
        catch (AddressException e1) {
            SkEmail.error("This email address is not valid: " + delta[0]);
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends InternetAddress> getReturnType() {
        return InternetAddress.class;
    }

    public String toString(Event e, boolean debug) {
        return "receivers of email";
    }

    static {
        Skript.registerExpression(ExprReceiversOfEmail.class, Address.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"%email%'s (receiver|recipient)[s]", "(receiver|recipient)[s] of %email%"});
    }
}

