/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skemail.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.olyno.skemail.SkEmail;
import com.olyno.skemail.effects.EffConnection;
import com.olyno.skemail.events.javaxmail.MailFolder;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import org.apache.commons.lang.ArrayUtils;
import org.bukkit.event.Event;

@Name(value="Last Emails")
@Description(value={"Return last received mails in a box."})
@Examples(value={"command read:\n\ttrigger:\n\t\tset {_mails::*} to last 2 mails\n\t\tbroadcast \"The author of the last received mail is %author of {_mails::1}%\""})
@Since(value="1.5")
public class ExprLastEmails
extends SimpleExpression<Message> {
    private Expression<Integer> start;
    private Expression<Integer> end;
    private Expression<Object> dir;
    private Expression<Object> connection;

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (matchedPattern == 0) {
            this.end = expr[0];
            this.dir = expr[1];
            this.connection = expr[2];
        } else {
            this.start = expr[0];
            this.end = expr[1];
            this.dir = expr[2];
            this.connection = expr[3];
        }
        return true;
    }

    protected Message[] get(Event e) {
        Session session = EffConnection.lastSession;
        String folderName = "INBOX";
        Integer startN = this.start != null ? (Integer)this.start.getSingle(e) : 0;
        Integer endN = this.end != null ? (Integer)this.end.getSingle(e) : -1;
        if (this.dir != null) {
            if (this.dir.getSingle(e) instanceof String) {
                folderName = (String)this.dir.getSingle(e);
            } else if (this.dir.getSingle(e) instanceof Folder) {
                folderName = ((Folder)this.dir.getSingle(e)).getName();
            }
        }
        if (this.connection != null) {
            if (this.connection.getSingle(e) instanceof String) {
                if (EffConnection.accounts.containsKey(this.connection.getSingle(e))) {
                    session = EffConnection.accounts.get(this.connection.getSingle(e));
                } else {
                    SkEmail.error("No account exists with this name: " + this.connection.getSingle(e));
                }
            } else if (this.connection.getSingle(e) instanceof Session) {
                session = (Session)this.connection.getSingle(e);
            } else {
                SkEmail.error("Connection type error. It's not a Session or String type: " + this.connection.getSingle(e).getClass().getName());
            }
        }
        try {
            Store store = session.getStore("imap");
            if (!store.isConnected()) {
                store.addFolderListener(new MailFolder());
                URLName urlname = store.getURLName();
                store.connect(urlname.getHost(), urlname.getPort(), urlname.getUsername(), urlname.getPassword());
            }
            Folder inbox = store.getFolder(folderName);
            inbox.open(1);
            if (endN == -1) {
                Object[] messages = inbox.getMessages();
                ArrayUtils.reverse((Object[])messages);
                return messages;
            }
            Message[] messages = new Message[endN - startN];
            for (int i = startN.intValue(); i < endN; ++i) {
                messages[i] = inbox.getMessage(inbox.getMessageCount() - i);
            }
            return messages;
        }
        catch (MessagingException e1) {
            e1.printStackTrace();
            return null;
        }
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends Message> getReturnType() {
        return Message.class;
    }

    public String toString(Event e, boolean debug) {
        return "last emails";
    }

    static {
        Skript.registerExpression(ExprLastEmails.class, Message.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"last[ly] [%-integer%] [e]mail[s] [in [(folder|dir)] (%-string%|%-folder%)] [(using|with) (%-session%|%-string%)]", "[e]mail[s] from %integer% to %integer% [in [(folder|dir)] (%-string%|%-folder%)] [(using|with) (%-session%|%-string%)]"});
    }
}

