/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skemail.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.olyno.skemail.SkEmail;
import com.olyno.skemail.types.IAddress;
import javax.mail.Message;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.bukkit.event.Event;

@Name(value="IAddress")
@Description(value={"Returns a internet address from a string."})
@Examples(value={""})
@Since(value="1.5")
public class ExprIAddress
extends SimpleExpression<IAddress> {
    private Expression<String> address;
    private Expression<Message.RecipientType> recipient;

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.address = expr[0];
        this.recipient = expr[1];
        return true;
    }

    protected IAddress[] get(Event e) {
        String addr = (String)this.address.getSingle(e);
        Message.RecipientType type = (Message.RecipientType)this.recipient.getSingle(e);
        try {
            InternetAddress internetAddress = new InternetAddress(addr);
            return new IAddress[]{new IAddress(internetAddress, type)};
        }
        catch (AddressException e1) {
            SkEmail.error("This email address is not valid: " + addr);
            return null;
        }
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends IAddress> getReturnType() {
        return IAddress.class;
    }

    public String toString(Event e, boolean debug) {
        return this.address.toString(e, debug) + " as " + this.recipient.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprIAddress.class, IAddress.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"%string% as %recipienttype%"});
    }
}

