/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skemail;

import java.io.IOException;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;

public class Utils {
    public static String getTextFromMessage(Message message) throws MessagingException, IOException {
        String result = "";
        if (message.isMimeType("text/plain")) {
            result = message.getContent().toString();
        } else if (message.isMimeType("multipart/*")) {
            MimeMultipart mimeMultipart = (MimeMultipart)message.getContent();
            result = Utils.getTextFromMimeMultipart(mimeMultipart);
        }
        return result;
    }

    private static String getTextFromMimeMultipart(MimeMultipart mimeMultipart) throws MessagingException, IOException {
        StringBuilder result = new StringBuilder();
        int count = mimeMultipart.getCount();
        for (int i = 0; i < count; ++i) {
            BodyPart bodyPart = mimeMultipart.getBodyPart(i);
            if (bodyPart.isMimeType("text/plain")) {
                result.append("\n").append(bodyPart.getContent());
                break;
            }
            if (bodyPart.isMimeType("text/html")) {
                String html = (String)bodyPart.getContent();
                result.append("\n").append(html);
                continue;
            }
            if (!(bodyPart.getContent() instanceof MimeMultipart)) continue;
            result.append(Utils.getTextFromMimeMultipart((MimeMultipart)bodyPart.getContent()));
        }
        return result.toString();
    }
}

