/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skemail.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.olyno.skemail.SkEmail;
import com.olyno.skemail.types.EmailService;
import java.util.regex.MatchResult;
import org.bukkit.event.Event;

@Name(value="Service")
@Description(value={"Returns the specified mail service. This service must to be loaded before use it."})
@Examples(value={"command /login:\n\ttrigger:\n\t\tset {_service} to new gmail service\n\t\tlogin to {_service} from mail \"myemail@gmail.com\" and password \"my password\""})
@Since(value="1.5")
public class ExprService
extends SimpleExpression<EmailService> {
    private String serviceName;

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.serviceName = ((MatchResult)parseResult.regexes.get(0)).group().toLowerCase();
        return true;
    }

    protected EmailService[] get(Event e) {
        if (EmailService.services.containsKey(this.serviceName)) {
            return new EmailService[]{EmailService.services.get(this.serviceName)};
        }
        SkEmail.error("This service doesn't exist: " + this.serviceName);
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends EmailService> getReturnType() {
        return EmailService.class;
    }

    public String toString(Event e, boolean debug) {
        return "email service " + this.serviceName;
    }

    static {
        Skript.registerExpression(ExprService.class, EmailService.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[new] <\\w+> (service|session)"});
    }
}

