/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skemail.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import java.util.Date;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.bukkit.event.Event;

@Name(value="Sent Date of Email")
@Description(value={"Returns the sent date of an email. Can be set in a email scope"})
@Examples(value={"make new email:", "\tset sent date of email to \"welcome on my new server!\""})
@Since(value="1.5")
public class ExprSentDateOfEmail
extends SimplePropertyExpression<Message, Date> {
    public Date convert(Message email) {
        try {
            return email.getSentDate();
        }
        catch (MessagingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE) {
            return new Class[]{String.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        try {
            for (Message email : (Message[])this.getExpr().getArray(e)) {
                switch (mode) {
                    case SET: {
                        email.setSentDate((Date)delta[0]);
                    }
                    case DELETE: {
                        email.setSentDate(null);
                    }
                }
            }
        }
        catch (MessagingException e1) {
            e1.printStackTrace();
        }
    }

    protected String getPropertyName() {
        return "sent date";
    }

    public Class<? extends Date> getReturnType() {
        return Date.class;
    }

    static {
        ExprSentDateOfEmail.register(ExprSentDateOfEmail.class, Date.class, (String)"sent date", (String)"email");
    }
}

