/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skemail.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.olyno.skemail.Utils;
import java.io.IOException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.bukkit.event.Event;

@Name(value="Body of Email")
@Description(value={"Returns the body of an email. Can be set in a email scope"})
@Examples(value={"make new email:", "\tset body of email to \"welcome on my new server!\""})
@Since(value="1.0")
public class ExprBodyOfEmail
extends SimplePropertyExpression<Message, String> {
    public String convert(Message email) {
        try {
            String result = Utils.getTextFromMessage(email);
            return result.isEmpty() ? null : result;
        }
        catch (IOException | MessagingException e1) {
            return null;
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE) {
            return new Class[]{String.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart body = new MimeBodyPart();
        block10: for (Message email : (Message[])this.getExpr().getArray(e)) {
            switch (mode) {
                case SET: {
                    try {
                        MimeMultipart current = (MimeMultipart)email.getContent();
                        for (int i = 0; i < current.getCount(); ++i) {
                            if (current.getBodyPart(i).getContentType().equals("text/plain")) continue;
                            ((Multipart)multipart).addBodyPart(current.getBodyPart(i));
                        }
                    }
                    catch (IOException | MessagingException exception) {
                        // empty catch block
                    }
                    try {
                        body.setContent(((String)delta[0]).replaceAll("\n", "<br>"), "text/html; charset=UTF-8");
                        ((Multipart)multipart).addBodyPart(body);
                        email.setContent(multipart);
                        continue block10;
                    }
                    catch (MessagingException messagingException) {
                        // empty catch block
                    }
                }
                case DELETE: {
                    try {
                        email.setContent(null, "text/html; charset=UTF-8");
                        continue block10;
                    }
                    catch (MessagingException messagingException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected String getPropertyName() {
        return "body";
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        ExprBodyOfEmail.register(ExprBodyOfEmail.class, String.class, (String)"(body|content)", (String)"email");
    }
}

