/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skemail.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.olyno.skemail.SkEmail;
import com.olyno.skemail.effects.EffConnection;
import com.olyno.skemail.util.AsyncEffect;
import java.util.concurrent.CompletionException;
import javax.mail.MessagingException;
import org.bukkit.event.Event;

@Name(value="Disconnection")
@Description(value={"Disconnection from one of your connected account."})
@Examples(value={"disconnect \"myemail@gmail.com\" from all connected mails"})
@Since(value="1.5")
public class EffDisconnection
extends AsyncEffect {
    private Expression<String> login;

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.login = expr[0];
        return true;
    }

    protected void execute(Event e) {
        String account = (String)this.login.getSingle(e);
        if (account.replaceAll(" ", "") != "") {
            if (EffConnection.accounts.containsKey(account)) {
                this.executeCode(e, () -> {
                    try {
                        EffConnection.accounts.get(account).getTransport().close();
                        EffConnection.accounts.remove(account);
                    }
                    catch (MessagingException ex) {
                        throw new CompletionException(ex);
                    }
                });
            }
        } else {
            SkEmail.error("You must to put a email address to remove it from all connected mails.");
        }
    }

    public String toString(Event e, boolean debug) {
        return "disconnection from \"" + this.login.toString(e, debug) + "\"";
    }

    static {
        Skript.registerEffect(EffDisconnection.class, (String[])new String[]{"(logout|disconnect) %string% [from [all] connected [e]mail[s]]"});
    }
}

