/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.skemail.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Variable;
import ch.njol.util.Kleenean;
import com.olyno.skemail.SkEmail;
import com.olyno.skemail.events.javaxmail.MailConnection;
import com.olyno.skemail.types.EmailService;
import com.olyno.skemail.util.AsyncEffect;
import java.util.HashMap;
import java.util.Properties;
import javax.mail.AuthenticationFailedException;
import javax.mail.Authenticator;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import org.apache.commons.lang.StringUtils;
import org.bukkit.event.Event;

@Name(value="Connection")
@Description(value={"Connect to your email account."})
@Examples(value={"login to gmail session \"email address of connection\" using pass \"password of the email address\""})
@Since(value="1.0")
public class EffConnection
extends AsyncEffect {
    public static HashMap<String, Session> accounts = new HashMap();
    public static Session lastSession;
    private Expression<EmailService> service;
    private Expression<String> user;
    private Expression<String> pass;
    private Expression<String> id;
    private Variable<?> varExpr;

    public boolean init(Expression<?>[] expr, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.service = expr[0];
        this.user = expr[1];
        this.pass = expr[2];
        if (expr[3] != null) {
            this.id = expr[3];
        }
        if (expr[4] != null && !(expr[4] instanceof Variable)) {
            SkEmail.error("You can register the connection in a var, and only in a var, not " + expr[4].toString());
            return false;
        }
        this.varExpr = (Variable)expr[4];
        return true;
    }

    protected void execute(Event e) {
        EmailService serviceType = (EmailService)this.service.getSingle(e);
        final String username = this.id != null ? (String)this.id.getSingle(e) : (String)this.user.getSingle(e);
        final String password = (String)this.pass.getSingle(e);
        if (StringUtils.isBlank((String)username) || StringUtils.isBlank((String)password)) {
            SkEmail.error("Your username and password can't be empty when you use connect's effect");
        }
        if (!accounts.containsKey(username)) {
            this.executeCode(e, () -> {
                try {
                    Properties props = new Properties();
                    props.put("mail.smtp.host", serviceType.getSmtp_address());
                    props.put("mail.smtp.port", (Object)Integer.parseInt(serviceType.getSmtp_port()));
                    props.put("mail.smtp.socketFactory.port", (Object)Integer.parseInt(serviceType.getSmtp_port()));
                    props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                    props.put("mail.smtp.auth", "true");
                    props.put("mail.imap.host", serviceType.getImap_address());
                    props.put("mail.imap.port", (Object)Integer.parseInt(serviceType.getImap_port()));
                    props.put("mail.imap.socketFactory.port", (Object)Integer.parseInt(serviceType.getImap_port()));
                    props.put("mail.imap.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                    props.put("mail.imap.auth", "true");
                    Session session = Session.getInstance(props, new Authenticator(){

                        @Override
                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(username, password);
                        }
                    });
                    Transport transport = session.getTransport("smtp");
                    if (!transport.isConnected()) {
                        transport.addConnectionListener(new MailConnection());
                        transport.connect(serviceType.getSmtp_address(), Integer.parseInt(serviceType.getSmtp_port()), username, password);
                        transport.close();
                        accounts.remove(username);
                        accounts.put(username, session);
                        lastSession = session;
                        if (this.varExpr != null) {
                            this.varExpr.change(e, new Object[]{session}, Changer.ChangeMode.SET);
                        }
                    }
                }
                catch (AuthenticationFailedException e1) {
                    SkEmail.error("You used a wrong mail address or password. Please check them. Else try to see if \"Less secure app access\" is turned on.");
                }
                catch (MessagingException e2) {
                    SkEmail.error("Impossible to connect to your mail box. Try to restart your server.");
                }
            });
        }
    }

    public String toString(Event e, boolean debug) {
        return "connection to mail " + this.user.toString(e, debug) + " and password " + this.pass.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffConnection.class, (String[])new String[]{"(login|connect) to %emailservice% [(account|session)] [(with|as|from) (address|user[name]|[e]mail)] %string% (and|using) [with] [pass[word]] %string% [as %-string%] [and store [it] in %-objects%]"});
    }
}

