/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.scopes;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.olyno.effects.EffConnection;
import com.olyno.expressions.ExprAttachFilesOfEmail;
import com.olyno.util.EffectSection;
import java.util.ArrayList;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.bukkit.event.Event;

@Name(value="Scope Email Creation")
@Description(value={"Scope for mail creation"})
@Examples(value={"make new email:", "\tset author of email to \"myemail@gmail.com\"", "\tset receiver of email to \"receiver@gmail.com\"", "\tset object of email to \"Welcome\"", "\tset body of email to \"Welcome on my new server!\"", "\tset attach file of email to \"plugin/Test/myfile.txt\""})
@Since(value="1.0")
public class ScopeEmailCreation
extends EffectSection {
    public static Message lastEmail;
    private Expression<Object> connection;

    public boolean init(Expression<?>[] expr, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        if (this.checkIfCondition()) {
            return false;
        }
        if (!this.hasSection()) {
            Skript.error((String)"An email creation scope is useless without any content!");
            return false;
        }
        this.connection = expr[0];
        this.loadSection(true);
        return true;
    }

    @Override
    public void execute(Event e) {
        Object c;
        Object object = c = this.connection == null ? null : this.connection.getSingle(e);
        Session session = c == null ? EffConnection.lastSession : (c instanceof String ? EffConnection.accounts.get(c) : (Session)c);
        lastEmail = new MimeMessage(session);
        EffConnection.lastSession = session;
        ExprAttachFilesOfEmail.files = new ArrayList<String>();
        this.runSection(e);
    }

    public String toString(Event e, boolean debug) {
        return "make new email " + lastEmail + (this.connection != null ? " with " + this.connection.toString(e, debug) : "");
    }

    static {
        Skript.registerCondition(ScopeEmailCreation.class, (String[])new String[]{"(make|do|create) [new] [e]mail [(using|with|for) [account] (%-session%|%-string%)]"});
    }
}

