/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.expressions.services;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.olyno.types.EmailService;
import org.bukkit.event.Event;

@Name(value="SMTP Address of Email Service")
@Description(value={"Returns the smtp address of an email service. Can be set in a email service scope"})
@Examples(value={"make new email service:", "\tset smtp address of service to \"smtp.myservice.com\""})
@Since(value="1.3")
public class ExprSMTPAddressOfService
extends SimplePropertyExpression<EmailService, String> {
    public String convert(EmailService service) {
        return service.getSmtp_address();
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE) {
            return new Class[]{String.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        block4: for (EmailService service : (EmailService[])this.getExpr().getArray(e)) {
            switch (mode) {
                case SET: {
                    service.setSmtp_address((String)delta[0]);
                    continue block4;
                }
                case DELETE: {
                    service.setSmtp_address(null);
                    continue block4;
                }
            }
        }
    }

    protected String getPropertyName() {
        return "smtp address";
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        ExprSMTPAddressOfService.register(ExprSMTPAddressOfService.class, String.class, (String)"smtp(-|_| )address", (String)"emailservice");
    }
}

