/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.olyno.scopes.ScopeEmailCreation;
import com.olyno.util.EffectSection;
import javax.mail.Message;
import org.bukkit.event.Event;

@Name(value="Email expression")
@Description(value={"If it isn't inside an email scope, this expression returns a new Email. If it is inside of an email scope, it returns the email that belongs to that scope."})
@Examples(value={"# outside a scope", "", "set {_e} to a new email", "", "# or in a scope", "", "make a new email:", "\tset object of email to \"TEST\"", "\tset body of email to \"Hey! That's a test!\"", "\tset receiver of email to \"hey@gmailcom\"", "\tadd \"plugins/myfile.txt\" to attachments of email", "set {_email} to last email"})
@Since(value="1.0")
public class ExprEmail
extends SimpleExpression<Message> {
    private boolean scope = false;

    public boolean init(Expression<?>[] expr, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.scope = EffectSection.isCurrentSection(ScopeEmailCreation.class);
        return this.scope;
    }

    protected Message[] get(Event e) {
        return new Message[]{this.scope ? ScopeEmailCreation.lastEmail : null};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Message> getReturnType() {
        return Message.class;
    }

    public String toString(Event e, boolean debug) {
        return "email";
    }

    static {
        Skript.registerExpression(ExprEmail.class, Message.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[(the|an|[a] new|this|that)] [e]mail [(creator|build[er])]"});
    }
}

