/*
 * Decompiled with CFR 0.152.
 */
package com.olyno.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.bukkit.event.Event;

@Name(value="Attach files of Email")
@Description(value={"Returns attach files of an email. Can be set in a email scope"})
@Examples(value={"make new email:", "\tset attachment of email to \"plugin/myfile.txt\""})
@Since(value="1.1")
public class ExprAttachFilesOfEmail
extends SimpleExpression<String> {
    public static List<String> files = new ArrayList<String>();
    private Expression<Message> message;

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.message = expr[0];
        return true;
    }

    protected String[] get(Event e) {
        return files.toArray(new String[files.size()]);
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.DELETE) {
            return new Class[]{String.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        try {
            Message email = (Message)this.message.getSingle(e);
            MimeMultipart multipart = new MimeMultipart();
            MimeMultipart ePart = (MimeMultipart)email.getContent();
            for (int i = 0; i < ePart.getCount(); ++i) {
                if ("attachment".equalsIgnoreCase(ePart.getBodyPart(i).getDisposition())) continue;
                ((Multipart)multipart).addBodyPart(ePart.getBodyPart(i));
                break;
            }
            block9: for (Object o : delta) {
                String file = (String)o;
                switch (mode) {
                    case SET: {
                        files = new ArrayList<String>(Arrays.asList(file));
                        continue block9;
                    }
                    case DELETE: {
                        files = new ArrayList<String>();
                        continue block9;
                    }
                    case ADD: {
                        files.add(file);
                        continue block9;
                    }
                    case REMOVE: {
                        files.remove(file);
                        continue block9;
                    }
                }
            }
            for (String f : files.toArray(new String[files.size()])) {
                MimeBodyPart attachPart = new MimeBodyPart();
                attachPart.attachFile(f);
                ((Multipart)multipart).addBodyPart(attachPart);
            }
            email.setContent(multipart);
        }
        catch (IOException | MessagingException e1) {
            e1.printStackTrace();
        }
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(Event e, boolean debug) {
        return "attached files";
    }

    static {
        Skript.registerExpression(ExprAttachFilesOfEmail.class, String.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"%email%['s] (attached file|attachment)[s]", "(attached file|attachment)[s] of %email%"});
    }
}

