/*
 * Decompiled with CFR 0.152.
 */
package com.olyno;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import com.olyno.Commands;
import com.olyno.Metrics;
import com.olyno.events.OnConnection;
import com.olyno.events.OnDisconnection;
import com.olyno.events.OnTransport;
import com.olyno.types.EmailService;
import com.olyno.util.Registration;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SkEmail
extends JavaPlugin {
    static SkEmail instance;
    private static File dataFolder;
    private static InputStream serviceResource;
    public List<Registration> expressions = new ArrayList<Registration>();
    SkriptAddon addon;

    public static void success(String success) {
        Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.GREEN + "[SkEmail] " + success);
    }

    public static void error(String error) {
        Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.RED + "[SkEmail] " + error);
    }

    public static void loadServices() {
        File servicesFile = new File(dataFolder, "services.yml");
        if (!servicesFile.exists()) {
            servicesFile.getParentFile().mkdirs();
            SkEmail.copy(serviceResource, servicesFile);
        }
        YamlConfiguration servicesYaml = YamlConfiguration.loadConfiguration((File)servicesFile);
        Set servicesList = servicesYaml.getKeys(false);
        for (String service : servicesList) {
            EmailService theService = new EmailService();
            if (servicesYaml.get(service + ".name") == null) {
                SkEmail.error("Can't load the service \"" + service + "\": It doesn't contain any name.");
                continue;
            }
            theService.setName((String)servicesYaml.get(service + ".name"));
            if (servicesYaml.get(service + ".smtp_address") == null) {
                SkEmail.error("Can't load the service \"" + service + "\": It doesn't contain any smtp address.");
                continue;
            }
            theService.setSmtp_address((String)servicesYaml.get(service + ".smtp_address"));
            if (servicesYaml.get(service + ".smtp_port") == null) {
                SkEmail.error("Can't load the service \"" + service + "\": It doesn't contain any smtp port.");
                continue;
            }
            theService.setSmtp_port(servicesYaml.get(service + ".smtp_port"));
            if (servicesYaml.get(service + ".imap_address") == null) {
                SkEmail.error("Can't load the service \"" + service + "\": It doesn't contain any imap address.");
                continue;
            }
            theService.setImap_address((String)servicesYaml.get(service + ".imap_address"));
            if (servicesYaml.get(service + ".imap_port") == null) {
                SkEmail.error("Can't load the service \"" + service + "\": It doesn't contain any imap port.");
                continue;
            }
            theService.setImap_port(servicesYaml.get(service + ".imap_port"));
            EmailService.services.remove(((String)servicesYaml.get(service + ".name")).toLowerCase());
            EmailService.services.put(((String)servicesYaml.get(service + ".name")).toLowerCase(), theService);
            SkEmail.success("Service named \"" + servicesYaml.get(service + ".name") + "\" has been loaded!");
        }
    }

    public static SkEmail getInstance() {
        return instance;
    }

    private static void copy(InputStream in, File file) {
        try {
            int len;
            FileOutputStream out = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((OutputStream)out).close();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SkriptAddon getAddonInstance() {
        return this.addon;
    }

    public void onEnable() {
        instance = this;
        this.addon = Skript.registerAddon((JavaPlugin)this);
        try {
            this.addon.loadClasses("com.olyno", new String[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Metrics metrics = new Metrics((Plugin)this);
        metrics.addCustomChart(new Metrics.SimplePie("used_language", () -> this.getConfig().getString("language", "en")));
        metrics.addCustomChart(new Metrics.SimplePie("skript_version", () -> Bukkit.getServer().getPluginManager().getPlugin("Skript").getDescription().getVersion()));
        metrics.addCustomChart(new Metrics.SimplePie("skemail_version", () -> this.getDescription().getVersion()));
        metrics.addCustomChart(new Metrics.DrilldownPie("java_version", () -> {
            HashMap map = new HashMap();
            String javaVersion = System.getProperty("java.version");
            HashMap<String, Integer> entry = new HashMap<String, Integer>();
            entry.put(javaVersion, 1);
            if (javaVersion.startsWith("1.7")) {
                map.put("Java 1.7", entry);
            } else if (javaVersion.startsWith("1.8")) {
                map.put("Java 1.8", entry);
            } else if (javaVersion.startsWith("1.9")) {
                map.put("Java 1.9", entry);
            } else {
                map.put("Other", entry);
            }
            return map;
        }));
        new OnConnection(this);
        new OnDisconnection(this);
        new OnTransport(this);
        this.getCommand("skemail").setExecutor((CommandExecutor)new Commands(this));
        dataFolder = this.getDataFolder();
        serviceResource = this.getResource("services.yml");
        SkEmail.loadServices();
    }
}

