/*
 * Decompiled with CFR 0.152.
 */
package fr.porcinet.skdisplay.utils;

import fr.porcinet.skdisplay.utils.Reflection;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.entity.Player;

public class Team {
    private static final Class PACKET_CLASS = Reflection.getClass("{nms}.PacketPlayOutScoreboardTeam");
    private static final Field TEAM_NAME = Reflection.getField(PACKET_CLASS, "a");
    private static final Field DISPLAY_NAME = Reflection.getField(PACKET_CLASS, "b");
    private static final Field PREFIX = Reflection.getField(PACKET_CLASS, "c");
    private static final Field SUFFIX = Reflection.getField(PACKET_CLASS, "d");
    private static final Field NAME_TAG_VISIBILITY = Reflection.getField(PACKET_CLASS, "e");
    private static final Field MEMBERS = Reflection.getField(PACKET_CLASS, "g");
    private static final Field TEAM_MODE = Reflection.getField(PACKET_CLASS, "h");
    private static final Field OPTIONS = Reflection.getField(PACKET_CLASS, "i");
    private static Set<Team> teams = new HashSet<Team>();
    private final String name;
    private String displayName = "";
    private String suffix = "\u00a7r";
    private String prefix = "";
    private Set<String> players = new HashSet<String>();
    private List<Player> viewers = null;
    private DyeColor teamColor;
    private boolean created = false;
    private NameTagVisibility nameTagVisibility = NameTagVisibility.ALWAYS;
    private boolean friendlyFire = true;
    private boolean seeFriendlyInvisibles = false;

    public Team(String name) {
        this(name, (List<Player>)null);
    }

    public Team(String name, DyeColor teamColor) {
        this(name, null, teamColor);
    }

    public Team(String name, List<Player> viewers) {
        this(name, "", name, "", new HashSet<String>(), viewers);
    }

    public Team(String name, List<Player> viewers, DyeColor teamColor) {
        this(name, "", name, "", new HashSet<String>(), viewers, teamColor);
    }

    public Team(String name, String displayName) {
        this(name, "", displayName, "", new HashSet<String>(), (List<Player>)null);
    }

    public Team(String name, String suffix, String displayName, String prefix) {
        this(name, suffix, displayName, prefix, new HashSet<String>(), (List<Player>)null);
    }

    public Team(String name, String suffix, String prefix, DyeColor teamColor) {
        this(name, suffix, name, prefix, new HashSet<String>(), null, teamColor);
    }

    public Team(String name, String suffix, String displayName, String prefix, DyeColor teamColor) {
        this(name, suffix, displayName, prefix, new HashSet<String>(), null, teamColor);
    }

    public Team(String name, String suffix, String displayName, String prefix, Set<String> players) {
        this(name, suffix, displayName, prefix, players, (List<Player>)null);
    }

    public Team(String name, String suffix, String displayName, String prefix, Set<String> players, DyeColor teamColor) {
        this(name, suffix, displayName, prefix, players, null, teamColor);
    }

    public Team(String name, String suffix, String displayName, String prefix, List<Player> viewers) {
        this(name, suffix, displayName, prefix, new HashSet<String>(), viewers);
    }

    public Team(String name, String suffix, String displayName, String prefix, Set<String> players, List<Player> viewers) {
        this(name, suffix, displayName, prefix, players, viewers, null);
    }

    public Team(String name, String suffix, String displayName, String prefix, Set<String> players, List<Player> viewers, DyeColor teamColor) {
        this.name = name;
        this.suffix = suffix;
        this.displayName = displayName;
        this.prefix = prefix;
        this.players = players;
        this.viewers = viewers;
        this.teamColor = teamColor;
    }

    public static Set<Team> getRegisterTeams() {
        return Collections.unmodifiableSet(teams);
    }

    public static Team getTeamOfPlayer(Player player) {
        for (Team team : Team.getRegisterTeams()) {
            if (!team.hasPlayer(player)) continue;
            return team;
        }
        return null;
    }

    public void create() {
        if (this.created) {
            this.update();
            return;
        }
        Reflection.sendPacket(this.getViewers(), this.constructDefaultPacket(TeamMode.CREATE));
        this.getPlayers().forEach(playerName -> Reflection.sendPacket(this.getViewers(), this.constructPlayerTeamPacket(TeamMode.ADD_PLAYER, (String)playerName)));
        this.created = true;
    }

    public void create(Player player) {
        if (this.isViewer(player)) {
            return;
        }
        Reflection.sendPacket(player, this.constructDefaultPacket(TeamMode.CREATE));
        this.getPlayers().forEach(playerName -> Reflection.sendPacket(this.getViewers(), this.constructPlayerTeamPacket(TeamMode.ADD_PLAYER, (String)playerName)));
    }

    public void update() {
        if (!this.created) {
            return;
        }
        Reflection.sendPacket(this.getViewers(), this.constructDefaultPacket(TeamMode.UPDATE));
    }

    public void update(Player player) {
        if (!this.isViewer(player)) {
            return;
        }
        Reflection.sendPacket(player, this.constructDefaultPacket(TeamMode.UPDATE));
    }

    public void updatePlayer(TeamMode mode, String playerName) {
        if (!this.created) {
            return;
        }
        Reflection.sendPacket(this.getViewers(), this.constructPlayerTeamPacket(mode, playerName));
    }

    public void remove() {
        if (!this.created) {
            return;
        }
        this.getPlayers().forEach(playerName -> this.constructPlayerTeamPacket(TeamMode.REMOVE_PLAYER, (String)playerName));
        Reflection.sendPacket(this.getViewers(), this.constructDefaultPacket(TeamMode.REMOVE));
        this.created = false;
    }

    public void remove(Player player) {
        if (!this.isViewer(player)) {
            return;
        }
        this.getPlayers().forEach(playerName -> this.constructPlayerTeamPacket(TeamMode.REMOVE_PLAYER, (String)playerName));
        Reflection.sendPacket(player, this.constructDefaultPacket(TeamMode.REMOVE));
    }

    public void delete() {
        if (this.created) {
            this.remove();
        }
        teams.remove(this);
    }

    private Object constructDefaultPacket(TeamMode mode) {
        if (mode != TeamMode.CREATE && mode != TeamMode.REMOVE && mode != TeamMode.UPDATE) {
            return null;
        }
        try {
            Object teamPacket = PACKET_CLASS.newInstance();
            Reflection.setFieldValue(teamPacket, TEAM_NAME, (Object)this.name);
            if (mode == TeamMode.REMOVE) {
                return teamPacket;
            }
            Reflection.setFieldValue(teamPacket, DISPLAY_NAME, (Object)this.displayName);
            Reflection.setFieldValue(teamPacket, PREFIX, (Object)this.prefix);
            Reflection.setFieldValue(teamPacket, SUFFIX, (Object)this.suffix);
            Reflection.setFieldValue(teamPacket, NAME_TAG_VISIBILITY, (Object)this.nameTagVisibility.getVisibility());
            Reflection.setFieldValue(teamPacket, MEMBERS, this.players);
            Reflection.setFieldValue(teamPacket, TEAM_MODE, (Object)mode.getMode());
            Reflection.setFieldValue(teamPacket, OPTIONS, (Object)this.packOptionData());
            return teamPacket;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Object constructPlayerTeamPacket(TeamMode mode, String playerName) {
        if (mode != TeamMode.ADD_PLAYER && mode != TeamMode.REMOVE_PLAYER) {
            return null;
        }
        try {
            Object teamPacket = PACKET_CLASS.newInstance();
            Reflection.setFieldValue(teamPacket, TEAM_NAME, (Object)this.name);
            Reflection.setFieldValue(teamPacket, MEMBERS, Collections.singleton(playerName));
            Reflection.setFieldValue(teamPacket, TEAM_MODE, (Object)mode.getMode());
            return teamPacket;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private int packOptionData() {
        int option = 0;
        if (this.allowFriendlyFire()) {
            option |= 1;
        }
        if (this.canSeeFriendlyInvisibles()) {
            option |= 2;
        }
        return option;
    }

    public void rebuildTeamPacket(Player p) {
        Reflection.sendPacket(p, this.constructDefaultPacket(TeamMode.CREATE));
        this.getPlayers().forEach(playerName -> Reflection.sendPacket(p, this.constructPlayerTeamPacket(TeamMode.ADD_PLAYER, (String)playerName)));
    }

    public boolean isCreated() {
        return this.created;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
        this.update();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
        this.update();
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
        this.update();
    }

    public boolean allowFriendlyFire() {
        return this.friendlyFire;
    }

    public void setFriendlyFire(boolean friendlyFire) {
        this.friendlyFire = friendlyFire;
        this.update();
    }

    public boolean canSeeFriendlyInvisibles() {
        return this.seeFriendlyInvisibles;
    }

    public void setSeeFriendlyInvisibles(boolean seeFriendlyInvisibles) {
        this.seeFriendlyInvisibles = seeFriendlyInvisibles;
        this.update();
    }

    public void addPlayer(Player player) {
        this.addPlayer(player.getName());
    }

    public void addPlayer(String playerName) {
        this.players.add(playerName);
        this.updatePlayer(TeamMode.ADD_PLAYER, playerName);
    }

    public boolean hasPlayer(Player player) {
        return this.players.contains(player.getName());
    }

    public boolean hasPlayer(String playerName) {
        return this.players.contains(playerName);
    }

    public void removePlayer(Player player) {
        this.removePlayer(player.getName());
    }

    public void removePlayer(String playerName) {
        this.players.remove(playerName);
        this.updatePlayer(TeamMode.REMOVE_PLAYER, playerName);
    }

    public DyeColor getTeamColor() {
        return this.teamColor;
    }

    public void setTeamColor(DyeColor teamColor) {
        this.teamColor = teamColor;
    }

    public void addViewer(Player player) {
        if (this.getViewers().contains(player)) {
            return;
        }
        this.viewers.add(player);
        this.create(player);
    }

    public boolean isViewer(Player player) {
        return this.getViewers().contains(player);
    }

    public void removeViewer(Player player) {
        if (!this.getViewers().contains(player)) {
            return;
        }
        this.viewers.remove(player);
        this.remove(player);
    }

    public List<Player> getViewers() {
        if (this.viewers == null) {
            this.viewers = new ArrayList<Player>();
            Bukkit.getOnlinePlayers().forEach(player -> this.viewers.add((Player)player));
        }
        return Collections.unmodifiableList(this.viewers);
    }

    public Set<String> getPlayers() {
        if (this.players == null) {
            this.players = new HashSet<String>();
        }
        return Collections.unmodifiableSet(this.players);
    }

    public static enum NameTagVisibility {
        ALWAYS("always"),
        NEVER("never"),
        HIDE_FOR_OTHER_TEAMS("hideForOtherTeams"),
        HIDE_FOR_OWN_TEAM("hideForOwnTeam");

        private final String visibility;

        private NameTagVisibility(String visibility) {
            this.visibility = visibility;
        }

        public final String getVisibility() {
            return this.visibility;
        }
    }

    public static enum TeamMode {
        CREATE(0),
        REMOVE(1),
        UPDATE(2),
        ADD_PLAYER(3),
        REMOVE_PLAYER(4);

        private final int mode;

        private TeamMode(int mode) {
            this.mode = mode;
        }

        public final int getMode() {
            return this.mode;
        }
    }
}

