/*
 * Decompiled with CFR 0.152.
 */
package fr.porcinet.skdisplay.utils;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Scoreboard;

public class Reflection {
    public static Class<?> getClass(String classname) {
        try {
            String version = Reflection.getNmsVersion();
            String path = classname.replace("{nms}", "net.minecraft.server." + version).replace("{nm}", "net.minecraft." + version).replace("{cb}", "org.bukkit.craftbukkit." + version);
            return Class.forName(path);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static Class<?> getArrayClass(String classname, int arraySize) {
        try {
            return Array.newInstance(Reflection.getClass(classname), arraySize).getClass();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static Enum getEnum(String enumClass, String enumValue) {
        return Enum.valueOf(Reflection.getClass(enumClass), enumValue);
    }

    public static String getNmsVersion() {
        return Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
    }

    public static Object getNmsPlayer(Player p) throws Exception {
        Method getHandle = p.getClass().getMethod("getHandle", new Class[0]);
        return getHandle.invoke((Object)p, new Object[0]);
    }

    public static Object getNmsScoreboard(Scoreboard s) throws Exception {
        Method getHandle = s.getClass().getMethod("getHandle", new Class[0]);
        return getHandle.invoke((Object)s, new Object[0]);
    }

    public static Object getFieldValue(Object instance, String fieldName) throws Exception {
        Field field = instance.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(instance);
    }

    public static Object getFieldValue(Object instance, Class clazz, String fieldName) throws Exception {
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(instance);
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        Field field = null;
        try {
            field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return field;
    }

    public static ArrayList<Field> getFields(Object instance, Class<?> fieldType) throws Exception {
        Field[] fields = instance.getClass().getDeclaredFields();
        ArrayList<Field> fieldArrayList = new ArrayList<Field>();
        for (Field field : fields) {
            if (field.getType() != fieldType) continue;
            field.setAccessible(true);
            fieldArrayList.add(field);
        }
        return fieldArrayList;
    }

    public static ArrayList<Field> getArraysFields(Object instance, Class<?> fieldType) throws Exception {
        String[] values = fieldType.toString().split(" ");
        String fieldName = values[values.length - 1];
        Field[] fields = instance.getClass().getDeclaredFields();
        ArrayList<Field> fieldArrayList = new ArrayList<Field>();
        for (Field field : fields) {
            if (!field.getType().isArray() || !field.getType().toString().contains(fieldName)) continue;
            field.setAccessible(true);
            fieldArrayList.add(field);
        }
        return fieldArrayList;
    }

    public static <T> T getFieldValue(Field field, Object obj) {
        try {
            return (T)field.get(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setFieldValue(Object instance, String field, Object value) {
        try {
            Field f = instance.getClass().getDeclaredField(field);
            f.setAccessible(true);
            f.set(instance, value);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void setFieldValue(Object instance, Field field, Object value) {
        field.setAccessible(true);
        try {
            field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static Field getFirstFieldByType(Class<?> clazz, Class<?> type) {
        for (Field field : clazz.getDeclaredFields()) {
            field.setAccessible(true);
            if (field.getType() != type) continue;
            return field;
        }
        return null;
    }

    public static Object getPlayerConnection(Player player) throws Exception {
        Object nmsPlayer = Reflection.getNmsPlayer(player);
        return nmsPlayer.getClass().getField("playerConnection").get(nmsPlayer);
    }

    public static void sendPacket(Object connection, Object packet) throws Exception {
        connection.getClass().getMethod("sendPacket", Reflection.getClass("{nms}.Packet")).invoke(connection, packet);
    }

    public static void sendPacket(Object packet) {
        Reflection.sendPacket(Bukkit.getOnlinePlayers(), packet);
    }

    public static void sendPacket(Collection<? extends Player> players, Object packet) {
        if (packet == null) {
            return;
        }
        try {
            for (Player player : players) {
                Reflection.sendPacket(Reflection.getPlayerConnection(player), packet);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void sendPacket(Player p, Object packet) {
        ArrayList<Player> list = new ArrayList<Player>();
        list.add(p);
        Reflection.sendPacket(list, packet);
    }

    public static void sendMessage(Player p, Object message) throws Exception {
        Object nmsPlayer = Reflection.getNmsPlayer(p);
        nmsPlayer.getClass().getMethod("sendMessage", Reflection.getClass("{nms}.IChatBaseComponent")).invoke(nmsPlayer, message);
    }

    public static int ping(Player p) throws Exception {
        Object nmsPlayer = Reflection.getNmsPlayer(p);
        return Integer.valueOf(Reflection.getFieldValue(nmsPlayer, "ping").toString());
    }
}

