/*
 * Decompiled with CFR 0.152.
 */
package fr.porcinet.skdisplay.nms.V_1_9_R1;

import fr.porcinet.skdisplay.interfaces.ScoreboardSign;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.v1_9_R1.IScoreboardCriteria;
import net.minecraft.server.v1_9_R1.Packet;
import net.minecraft.server.v1_9_R1.PacketPlayOutScoreboardDisplayObjective;
import net.minecraft.server.v1_9_R1.PacketPlayOutScoreboardObjective;
import net.minecraft.server.v1_9_R1.PacketPlayOutScoreboardScore;
import net.minecraft.server.v1_9_R1.PacketPlayOutScoreboardTeam;
import net.minecraft.server.v1_9_R1.PlayerConnection;
import org.bukkit.craftbukkit.v1_9_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class ScoreboardSign_1_9_R1
implements ScoreboardSign {
    private boolean created = false;
    private final VirtualTeam[] lines = new VirtualTeam[15];
    private final Player player;
    private String objectiveName;

    public ScoreboardSign_1_9_R1(Player player, String objectiveName) {
        this.player = player;
        this.objectiveName = objectiveName;
    }

    @Override
    public void create() {
        if (this.created) {
            return;
        }
        PlayerConnection player = this.getPlayer();
        player.sendPacket((Packet)this.createObjectivePacket(0, this.objectiveName));
        player.sendPacket((Packet)this.setObjectiveSlot());
        int i = 0;
        while (i < this.lines.length) {
            this.sendLine(i++);
        }
        this.created = true;
    }

    @Override
    public void destroy() {
        if (!this.created) {
            return;
        }
        this.getPlayer().sendPacket((Packet)this.createObjectivePacket(1, null));
        for (VirtualTeam team : this.lines) {
            if (team == null) continue;
            this.getPlayer().sendPacket((Packet)team.removeTeam());
        }
        this.created = false;
    }

    @Override
    public void setObjectiveName(String name) {
        this.objectiveName = name;
        if (this.created) {
            this.getPlayer().sendPacket((Packet)this.createObjectivePacket(2, name));
        }
    }

    @Override
    public void setLine(int line, String value) {
        VirtualTeam team = this.getOrCreateTeam(line);
        String old = team.getCurrentPlayer();
        if (old != null && this.created) {
            this.getPlayer().sendPacket((Packet)this.removeLine(old));
        }
        team.setValue(value);
        this.sendLine(line);
    }

    @Override
    public void removeLine(int line) {
        VirtualTeam team = this.getOrCreateTeam(line);
        String old = team.getCurrentPlayer();
        if (old != null && this.created) {
            this.getPlayer().sendPacket((Packet)this.removeLine(old));
            this.getPlayer().sendPacket((Packet)team.removeTeam());
        }
        this.lines[line] = null;
    }

    public String getLine(int line) {
        if (line > 14) {
            return null;
        }
        if (line < 0) {
            return null;
        }
        return this.getOrCreateTeam(line).getValue();
    }

    public VirtualTeam getTeam(int line) {
        if (line > 14) {
            return null;
        }
        if (line < 0) {
            return null;
        }
        return this.getOrCreateTeam(line);
    }

    private PlayerConnection getPlayer() {
        return ((CraftPlayer)this.player).getHandle().playerConnection;
    }

    private void sendLine(int line) {
        if (line > 14) {
            return;
        }
        if (line < 0) {
            return;
        }
        if (!this.created) {
            return;
        }
        int score = 15 - line;
        VirtualTeam val = this.getOrCreateTeam(line);
        for (Packet packet : val.sendLine()) {
            this.getPlayer().sendPacket(packet);
        }
        this.getPlayer().sendPacket((Packet)this.sendScore(val.getCurrentPlayer(), score));
        val.reset();
    }

    private VirtualTeam getOrCreateTeam(int line) {
        if (this.lines[line] == null) {
            this.lines[line] = new VirtualTeam("__fakeScore" + line);
        }
        return this.lines[line];
    }

    private PacketPlayOutScoreboardObjective createObjectivePacket(int mode, String displayName) {
        PacketPlayOutScoreboardObjective packet = new PacketPlayOutScoreboardObjective();
        ScoreboardSign_1_9_R1.setField(packet, "a", this.player.getName());
        ScoreboardSign_1_9_R1.setField(packet, "d", mode);
        if (mode == 0 || mode == 2) {
            ScoreboardSign_1_9_R1.setField(packet, "b", displayName);
            ScoreboardSign_1_9_R1.setField(packet, "c", IScoreboardCriteria.EnumScoreboardHealthDisplay.INTEGER);
        }
        return packet;
    }

    private PacketPlayOutScoreboardDisplayObjective setObjectiveSlot() {
        PacketPlayOutScoreboardDisplayObjective packet = new PacketPlayOutScoreboardDisplayObjective();
        ScoreboardSign_1_9_R1.setField(packet, "a", 1);
        ScoreboardSign_1_9_R1.setField(packet, "b", this.player.getName());
        return packet;
    }

    private PacketPlayOutScoreboardScore sendScore(String line, int score) {
        PacketPlayOutScoreboardScore packet = new PacketPlayOutScoreboardScore(line);
        ScoreboardSign_1_9_R1.setField(packet, "b", this.player.getName());
        ScoreboardSign_1_9_R1.setField(packet, "c", score);
        ScoreboardSign_1_9_R1.setField(packet, "d", PacketPlayOutScoreboardScore.EnumScoreboardAction.CHANGE);
        return packet;
    }

    private PacketPlayOutScoreboardScore removeLine(String line) {
        return new PacketPlayOutScoreboardScore(line);
    }

    private static void setField(Object edit, String fieldName, Object value) {
        try {
            Field field = edit.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(edit, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public class VirtualTeam {
        private final String name;
        private String prefix;
        private String suffix;
        private String currentPlayer;
        private String oldPlayer;
        private boolean prefixChanged;
        private boolean suffixChanged;
        private boolean playerChanged = false;
        private boolean first = true;

        private VirtualTeam(String name, String prefix, String suffix) {
            this.name = name;
            this.prefix = prefix;
            this.suffix = suffix;
        }

        private VirtualTeam(String name) {
            this(name, "", "");
        }

        public String getName() {
            return this.name;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            if (this.prefix == null || !this.prefix.equals(prefix)) {
                this.prefixChanged = true;
            }
            this.prefix = prefix;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public void setSuffix(String suffix) {
            if (this.suffix == null || !this.suffix.equals(this.prefix)) {
                this.suffixChanged = true;
            }
            this.suffix = suffix;
        }

        private PacketPlayOutScoreboardTeam createPacket(int mode) {
            PacketPlayOutScoreboardTeam packet = new PacketPlayOutScoreboardTeam();
            ScoreboardSign_1_9_R1.setField(packet, "a", this.name);
            ScoreboardSign_1_9_R1.setField(packet, "b", "");
            ScoreboardSign_1_9_R1.setField(packet, "c", this.prefix);
            ScoreboardSign_1_9_R1.setField(packet, "d", this.suffix);
            ScoreboardSign_1_9_R1.setField(packet, "i", 0);
            ScoreboardSign_1_9_R1.setField(packet, "e", "always");
            ScoreboardSign_1_9_R1.setField(packet, "g", 0);
            ScoreboardSign_1_9_R1.setField(packet, "i", mode);
            return packet;
        }

        public PacketPlayOutScoreboardTeam createTeam() {
            return this.createPacket(0);
        }

        public PacketPlayOutScoreboardTeam updateTeam() {
            return this.createPacket(2);
        }

        public PacketPlayOutScoreboardTeam removeTeam() {
            PacketPlayOutScoreboardTeam packet = new PacketPlayOutScoreboardTeam();
            ScoreboardSign_1_9_R1.setField(packet, "a", this.name);
            ScoreboardSign_1_9_R1.setField(packet, "i", 1);
            this.first = true;
            return packet;
        }

        public void setPlayer(String name) {
            if (this.currentPlayer == null || !this.currentPlayer.equals(name)) {
                this.playerChanged = true;
            }
            this.oldPlayer = this.currentPlayer;
            this.currentPlayer = name;
        }

        public Iterable<PacketPlayOutScoreboardTeam> sendLine() {
            ArrayList<PacketPlayOutScoreboardTeam> packets = new ArrayList<PacketPlayOutScoreboardTeam>();
            if (this.first) {
                packets.add(this.createTeam());
            } else if (this.prefixChanged || this.suffixChanged) {
                packets.add(this.updateTeam());
            }
            if (this.first || this.playerChanged) {
                if (this.oldPlayer != null) {
                    packets.add(this.addOrRemovePlayer(4, this.oldPlayer));
                }
                packets.add(this.changePlayer());
            }
            if (this.first) {
                this.first = false;
            }
            return packets;
        }

        public void reset() {
            this.prefixChanged = false;
            this.suffixChanged = false;
            this.playerChanged = false;
            this.oldPlayer = null;
        }

        public PacketPlayOutScoreboardTeam changePlayer() {
            return this.addOrRemovePlayer(3, this.currentPlayer);
        }

        public PacketPlayOutScoreboardTeam addOrRemovePlayer(int mode, String playerName) {
            PacketPlayOutScoreboardTeam packet = new PacketPlayOutScoreboardTeam();
            ScoreboardSign_1_9_R1.setField(packet, "a", this.name);
            ScoreboardSign_1_9_R1.setField(packet, "i", mode);
            try {
                Field f = packet.getClass().getDeclaredField("h");
                f.setAccessible(true);
                ((List)f.get(packet)).add(playerName);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
            return packet;
        }

        public String getCurrentPlayer() {
            return this.currentPlayer;
        }

        public String getValue() {
            return this.getPrefix() + this.getCurrentPlayer() + this.getSuffix();
        }

        public void setValue(String value) {
            if (value.length() <= 16) {
                this.setPrefix("");
                this.setSuffix("");
                this.setPlayer(value);
            } else if (value.length() <= 32) {
                this.setPrefix(value.substring(0, 16));
                this.setPlayer(value.substring(16));
                this.setSuffix("");
            } else if (value.length() <= 48) {
                this.setPrefix(value.substring(0, 16));
                this.setPlayer(value.substring(16, 32));
                this.setSuffix(value.substring(32));
            } else {
                throw new IllegalArgumentException("Too long value ! Max 48 characters, value was " + value.length() + " !");
            }
        }
    }
}

