/*
 * Decompiled with CFR 0.152.
 */
package fr.porcinet.skdisplay.nms.V_1_8_R1;

import fr.porcinet.skdisplay.interfaces.ScoreboardSign;
import fr.porcinet.skdisplay.utils.Reflection;
import fr.porcinet.skdisplay.utils.Team;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.UUID;
import net.minecraft.server.v1_8_R1.EnumScoreboardAction;
import net.minecraft.server.v1_8_R1.EnumScoreboardHealthDisplay;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class ScoreboardSign_1_8_R1
implements ScoreboardSign {
    private static final Class OBJECTIVE_PACKET_CLASS = Reflection.getClass("{nms}.PacketPlayOutScoreboardObjective");
    private static final Field O_NAME = Reflection.getField(OBJECTIVE_PACKET_CLASS, "a");
    private static final Field O_VALUE = Reflection.getField(OBJECTIVE_PACKET_CLASS, "b");
    private static final Field O_TYPE = Reflection.getField(OBJECTIVE_PACKET_CLASS, "c");
    private static final Field O_MODE = Reflection.getField(OBJECTIVE_PACKET_CLASS, "d");
    private static final Class DISPLAY_OBJECTIVE_PACKET_CLASS = Reflection.getClass("{nms}.PacketPlayOutScoreboardDisplayObjective");
    private static final Field DO_SLOT = Reflection.getField(DISPLAY_OBJECTIVE_PACKET_CLASS, "a");
    private static final Field DO_OBJ_NAME = Reflection.getField(DISPLAY_OBJECTIVE_PACKET_CLASS, "b");
    private static final Class SCORE_PACKET_CLASS = Reflection.getClass("{nms}.PacketPlayOutScoreboardScore");
    private static final Field S_SCORE_NAME = Reflection.getField(SCORE_PACKET_CLASS, "a");
    private static final Field S_OBJ_NAME = Reflection.getField(SCORE_PACKET_CLASS, "b");
    private static final Field S_SCORE_INT = Reflection.getField(SCORE_PACKET_CLASS, "c");
    private static final Field S_ACTION = Reflection.getField(SCORE_PACKET_CLASS, "d");
    private final Team[] lines = new Team[15];
    private UUID playerUUID;
    private String objectiveName;
    private ScoreboardSlot slot;
    private boolean created = false;

    public ScoreboardSign_1_8_R1(UUID playerUUID, String objectiveName, ScoreboardSlot slot) {
        this.playerUUID = playerUUID;
        this.objectiveName = objectiveName;
        this.slot = slot;
    }

    @Override
    public void create() {
        if (this.created) {
            return;
        }
        Reflection.sendPacket(this.getPlayer(), this.createObjectivePacket(ScoreboardMode.CREATE, this.objectiveName));
        Reflection.sendPacket(this.getPlayer(), this.setObjectiveSlot(this.slot));
        int i = 0;
        while (i < this.lines.length) {
            this.sendLine(i++);
        }
        this.created = true;
    }

    public void update() {
        if (!this.created) {
            return;
        }
        Reflection.sendPacket(this.getPlayer(), this.createObjectivePacket(ScoreboardMode.UPDATE, this.objectiveName));
    }

    @Override
    public void destroy() {
        if (!this.created) {
            return;
        }
        Reflection.sendPacket(this.getPlayer(), this.createObjectivePacket(ScoreboardMode.REMOVE, null));
        for (Team team : this.lines) {
            if (team == null || !team.isCreated()) continue;
            team.remove();
        }
        this.created = false;
    }

    @Override
    public void setObjectiveName(String name) {
        this.objectiveName = name;
        if (this.created) {
            Reflection.sendPacket(this.getPlayer(), this.createObjectivePacket(ScoreboardMode.UPDATE, name));
        }
    }

    @Override
    public void setLine(int line, String value) {
        Team team = this.getOrCreateTeam(line);
        String old = this.getValue(team);
        if (old != null && this.created) {
            this.removeLine(team, old);
        }
        this.setValue(team, value);
        this.sendLine(line);
    }

    @Override
    public void removeLine(int line) {
        Team team = this.getOrCreateTeam(line);
        String old = this.getValue(team);
        if (!this.created) {
            return;
        }
        if (old != null) {
            this.removeLine(team, old);
        }
    }

    public String getLine(int line) {
        if (line > 14 || line < 0) {
            return "";
        }
        return this.getValue(this.getOrCreateTeam(line));
    }

    private void sendLine(int line) {
        if (line > 14 || line < 0) {
            return;
        }
        if (!this.created) {
            return;
        }
        int score = 15 - line;
        Team team = this.getOrCreateTeam(line);
        String lineValue = this.getValue(team);
        Reflection.sendPacket(this.getPlayer(), this.sendScore(lineValue, score));
    }

    private void removeLine(Team team, String scoreName) {
        try {
            team.removePlayer(team.getPlayers().iterator().next());
            Reflection.sendPacket(this.getPlayer(), SCORE_PACKET_CLASS.getDeclaredConstructor(String.class).newInstance(scoreName));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Team getOrCreateTeam(int line) {
        if (this.lines[line] == null) {
            this.lines[line] = new Team("__fakeScore" + line, Collections.singletonList(this.getPlayer()));
            this.lines[line].create();
        }
        return this.lines[line];
    }

    private Player getPlayer() {
        Player player = Bukkit.getPlayer((UUID)this.playerUUID);
        if (player == null) {
            throw new NullPointerException("The player of uuid " + this.playerUUID.toString() + " isn't online !");
        }
        return player;
    }

    private void setValue(Team team, String value) {
        int length = value.length();
        if (length <= 16) {
            team.setPrefix("");
            team.addPlayer(value);
            team.setSuffix("");
        } else if (value.length() <= 32) {
            team.setPrefix(value.substring(0, 16));
            team.addPlayer(value.substring(16));
            team.setSuffix("");
        } else if (value.length() <= 48) {
            team.setPrefix(value.substring(0, 16));
            team.addPlayer(value.substring(16, 32));
            team.setSuffix(value.substring(32));
        } else {
            throw new IllegalArgumentException("Too long value ! Max 48 characters, value was " + length + " !");
        }
    }

    private String getValue(Team team) {
        if (!team.getPlayers().iterator().hasNext()) {
            return null;
        }
        return team.getPrefix() + team.getPlayers().iterator().next() + team.getSuffix();
    }

    private Object createObjectivePacket(ScoreboardMode mode, String displayName) {
        try {
            Object packet = OBJECTIVE_PACKET_CLASS.newInstance();
            Reflection.setFieldValue(packet, O_NAME, (Object)this.getPlayer().getName());
            Reflection.setFieldValue(packet, O_MODE, (Object)mode.getMode());
            if (mode != ScoreboardMode.REMOVE) {
                Reflection.setFieldValue(packet, O_VALUE, (Object)displayName);
                Reflection.setFieldValue(packet, O_TYPE, (Object)EnumScoreboardHealthDisplay.INTEGER);
            }
            return packet;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Object setObjectiveSlot(ScoreboardSlot slot) {
        try {
            Object packet = DISPLAY_OBJECTIVE_PACKET_CLASS.newInstance();
            Reflection.setFieldValue(packet, DO_SLOT, (Object)slot.getMode());
            Reflection.setFieldValue(packet, DO_OBJ_NAME, (Object)this.getPlayer().getName());
            return packet;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Object sendScore(String line, int score) {
        try {
            Object packet = SCORE_PACKET_CLASS.getDeclaredConstructor(String.class).newInstance(line);
            Reflection.setFieldValue(packet, S_OBJ_NAME, (Object)this.getPlayer().getName());
            Reflection.setFieldValue(packet, S_SCORE_INT, (Object)score);
            Reflection.setFieldValue(packet, S_ACTION, (Object)EnumScoreboardAction.CHANGE);
            return packet;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static enum ScoreMode {
        CREATE_OR_UPDATE(0),
        REMOVE(1);

        private final int mode;

        private ScoreMode(int mode) {
            this.mode = mode;
        }

        public final int getMode() {
            return this.mode;
        }
    }

    public static enum ScoreboardSlot {
        LIST(0),
        SIDEBAR(1),
        BELOW_NAME(2);

        private final int mode;

        private ScoreboardSlot(int mode) {
            this.mode = mode;
        }

        public final int getMode() {
            return this.mode;
        }
    }

    public static enum ScoreboardMode {
        CREATE(0),
        REMOVE(1),
        UPDATE(2);

        private final int mode;

        private ScoreboardMode(int mode) {
            this.mode = mode;
        }

        public final int getMode() {
            return this.mode;
        }
    }
}

