/*
 * Decompiled with CFR 0.152.
 */
package fr.porcinet.skdisplay;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.expressions.base.EventValueExpression;
import ch.njol.skript.lang.DefaultExpression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import com.mojang.authlib.properties.Property;
import fr.porcinet.skdisplay.SkDisplayListeners;
import fr.porcinet.skdisplay.commands.CmdSkDisplay;
import fr.porcinet.skdisplay.effects.EffAddHoverCooldown;
import fr.porcinet.skdisplay.effects.EffEffectNpc;
import fr.porcinet.skdisplay.effects.EffSpawnNpc;
import fr.porcinet.skdisplay.effects.scoreboard.EffAddLineScoreboard;
import fr.porcinet.skdisplay.effects.scoreboard.EffCreateScoreboard;
import fr.porcinet.skdisplay.effects.scoreboard.EffDestroyScoreboad;
import fr.porcinet.skdisplay.effects.scoreboard.EffRemoveLineScoreboard;
import fr.porcinet.skdisplay.effects.scoreboard.EffSetTitleScoreboard;
import fr.porcinet.skdisplay.effects.skin.EffResetPlayerSkin;
import fr.porcinet.skdisplay.effects.skin.EffSetPlayerSkin;
import fr.porcinet.skdisplay.types.Npc;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.server.v1_12_R1.EntityPlayer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SkDisplay
extends JavaPlugin {
    public static SkDisplay plugin;
    public static File npc_folder;
    public static String version;
    public static Map<String, Property> skinCache;
    public static Map<Integer, EntityPlayer> npc_list;
    public static Map<Player, Integer> npc_corpse;
    public static Map<Player, Integer> npc_client;

    public void onEnable() {
        this.saveDefaultConfig();
        plugin = this;
        npc_folder = new File(this.getDataFolder() + File.separator + "npc");
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
        if (!npc_folder.exists()) {
            npc_folder.mkdir();
        }
        System.out.println("[SkDisplay] You're running on " + version);
        this.getServer().getPluginManager().registerEvents((Listener)new SkDisplayListeners(), (Plugin)this);
        Skript.registerAddon((JavaPlugin)this);
        Skript.registerEffect(EffCreateScoreboard.class, (String[])new String[]{"[skdisplay] create score[board] (named|titled) %string% for %player%"});
        Skript.registerEffect(EffAddLineScoreboard.class, (String[])new String[]{"[skdisplay] set score[board] [line] %integer% to %string% for %player%"});
        Skript.registerEffect(EffDestroyScoreboad.class, (String[])new String[]{"[skdisplay] (destroy|remove) score[board] of %player%"});
        Skript.registerEffect(EffSetTitleScoreboard.class, (String[])new String[]{"[skdisplay] (set|update|modify|edit) score[board] (title|named) to %string% for %player%"});
        Skript.registerEffect(EffRemoveLineScoreboard.class, (String[])new String[]{"[skdisplay] (remove|delete) score[board] line %integer% for %player%"});
        Skript.registerEffect(EffSetPlayerSkin.class, (String[])new String[]{"[skdisplay] set %player%['s] skin [texture] to %offlineplayer%"});
        Skript.registerEffect(EffResetPlayerSkin.class, (String[])new String[]{"[skdisplay] reset %player%['s] skin [texture]"});
        Skript.registerEffect(EffSpawnNpc.class, (String[])new String[]{"(create|spawn|register) [a] npc named %string% at %location% [and store (it|the message) in %-objects%]"});
        Skript.registerEffect(EffEffectNpc.class, (String[])new String[]{"add effect to %npc% for %player%"});
        SkDisplay.types();
        if (!(version.equals("v1_8_R1") && version.equals("v1_8_R2") && version.equals("v1_8_R3"))) {
            Skript.registerEffect(EffAddHoverCooldown.class, (String[])new String[]{"[skdisplay] (add|set) [hover] cooldown to %itemstack% for %timespan% for %player%"});
        }
        this.getCommand("skdisplay").setExecutor((CommandExecutor)new CmdSkDisplay());
        try {
            FileInputStream fileIn = new FileInputStream(npc_folder + File.separator + "npc_list.txt");
            ObjectInputStream ois = new ObjectInputStream(fileIn);
            npc_list = (HashMap)ois.readObject();
            ois.close();
            fileIn.close();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void onDisable() {
        try {
            FileOutputStream fileOut = new FileOutputStream(npc_folder + File.separator + "npc_list.txt");
            ObjectOutputStream out = new ObjectOutputStream(fileOut);
            out.writeObject(npc_list);
            out.close();
            fileOut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void types() {
        String codeName = "npc";
        if (Classes.getClassInfoNoError((String)codeName) != null) {
            codeName = "npctype";
        }
        Classes.registerClass((ClassInfo)new ClassInfo(Npc.class, codeName).user(new String[]{"npc(s)?"}).name("Npc").description(new String[]{"An type that represents the Npc class within Skript."}).defaultExpression((DefaultExpression)new EventValueExpression(Npc.class)).parser((Parser)new Parser<Npc>(){

            @Nullable
            public Npc parse(String s, ParseContext context) {
                return null;
            }

            public String toVariableNameString(Npc npc) {
                return npc.getEntity().toString();
            }

            public String getVariableNamePattern() {
                return ".+";
            }

            public String toString(Npc npc, int flags) {
                return npc.toString();
            }
        }));
    }

    static {
        version = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
        skinCache = new HashMap<String, Property>();
        npc_list = new HashMap<Integer, EntityPlayer>();
        npc_corpse = new HashMap<Player, Integer>();
        npc_client = new HashMap<Player, Integer>();
    }
}

