/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.skboard.objects;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import tk.shanebee.skboard.SkBoard;

public class Board {
    private static final Map<Player, Board> BOARD_MAP = new HashMap<Player, Board>();
    private final SkBoard plugin = SkBoard.getInstance();
    private final Player player;
    private final Scoreboard scoreboard;
    private final Objective board;
    private final Team line1;
    private final Team line2;
    private final Team line3;
    private final Team line4;
    private final Team line5;
    private final Team line6;
    private final Team line7;
    private final Team line8;
    private final Team line9;
    private final Team line10;
    private final Team line11;
    private final Team line12;
    private final Team line13;
    private final Team line14;
    private final Team line15;
    private boolean on;

    public static Board getBoard(Player player) {
        return BOARD_MAP.get(player);
    }

    public static void createBoard(Player player) {
        Board board = new Board(player, false);
        BOARD_MAP.put(player, board);
    }

    public static void loadBoard(Player player) {
        Board board = new Board(player, true);
        BOARD_MAP.put(player, board);
    }

    public static void removeBoard(Player player) {
        BOARD_MAP.remove(player);
    }

    public static void clearBoards() {
        BOARD_MAP.clear();
    }

    public Board(Player player, boolean load) {
        this.player = player;
        this.on = true;
        if (!load) {
            this.scoreboard = this.plugin.getServer().getScoreboardManager().getNewScoreboard();
            this.player.setScoreboard(this.scoreboard);
            this.board = this.scoreboard.registerNewObjective("Board", "dummy", "Board");
            this.board.setDisplaySlot(DisplaySlot.SIDEBAR);
            this.board.setDisplayName("");
            this.line1 = this.scoreboard.registerNewTeam("line1");
            this.line2 = this.scoreboard.registerNewTeam("line2");
            this.line3 = this.scoreboard.registerNewTeam("line3");
            this.line4 = this.scoreboard.registerNewTeam("line4");
            this.line5 = this.scoreboard.registerNewTeam("line5");
            this.line6 = this.scoreboard.registerNewTeam("line6");
            this.line7 = this.scoreboard.registerNewTeam("line7");
            this.line8 = this.scoreboard.registerNewTeam("line8");
            this.line9 = this.scoreboard.registerNewTeam("line9");
            this.line10 = this.scoreboard.registerNewTeam("line10");
            this.line11 = this.scoreboard.registerNewTeam("line11");
            this.line12 = this.scoreboard.registerNewTeam("line12");
            this.line13 = this.scoreboard.registerNewTeam("line13");
            this.line14 = this.scoreboard.registerNewTeam("line14");
            this.line15 = this.scoreboard.registerNewTeam("line15");
            this.line1.addEntry(this.getColString("&1"));
            this.line2.addEntry(this.getColString("&2"));
            this.line3.addEntry(this.getColString("&3"));
            this.line4.addEntry(this.getColString("&4"));
            this.line5.addEntry(this.getColString("&5"));
            this.line6.addEntry(this.getColString("&6"));
            this.line7.addEntry(this.getColString("&7"));
            this.line8.addEntry(this.getColString("&8"));
            this.line9.addEntry(this.getColString("&9"));
            this.line10.addEntry(this.getColString("&0"));
            this.line11.addEntry(this.getColString("&a"));
            this.line12.addEntry(this.getColString("&b"));
            this.line13.addEntry(this.getColString("&c"));
            this.line14.addEntry(this.getColString("&d"));
            this.line15.addEntry(this.getColString("&e"));
        } else {
            this.scoreboard = player.getScoreboard();
            this.board = this.scoreboard.getObjective("Board");
            this.line1 = this.scoreboard.getTeam("line1");
            this.line2 = this.scoreboard.getTeam("line2");
            this.line3 = this.scoreboard.getTeam("line3");
            this.line4 = this.scoreboard.getTeam("line4");
            this.line5 = this.scoreboard.getTeam("line5");
            this.line6 = this.scoreboard.getTeam("line6");
            this.line7 = this.scoreboard.getTeam("line7");
            this.line8 = this.scoreboard.getTeam("line8");
            this.line9 = this.scoreboard.getTeam("line9");
            this.line10 = this.scoreboard.getTeam("line10");
            this.line11 = this.scoreboard.getTeam("line11");
            this.line12 = this.scoreboard.getTeam("line12");
            this.line13 = this.scoreboard.getTeam("line13");
            this.line14 = this.scoreboard.getTeam("line14");
            this.line15 = this.scoreboard.getTeam("line15");
        }
    }

    public void setTitle(String title) {
        this.board.setDisplayName(this.getColString(title));
    }

    public void setLine(int line, String text) {
        Team t = this.getLine(line);
        t.setPrefix(this.getColString(text));
        this.board.getScore(this.getEntry(line)).setScore(line);
    }

    public void deleteLine(int line) {
        Team t = this.getLine(line);
        this.scoreboard.resetScores(this.getEntry(line));
    }

    public void clearBoard() {
        for (int i = 1; i < 16; ++i) {
            this.deleteLine(i);
        }
    }

    public void toggle(boolean on) {
        if (on) {
            this.player.setScoreboard(this.scoreboard);
            this.on = true;
        } else {
            this.player.setScoreboard(this.plugin.getServer().getScoreboardManager().getNewScoreboard());
            this.on = false;
        }
    }

    public boolean isOn() {
        return this.on;
    }

    private Team getLine(int line) {
        switch (line) {
            case 2: {
                return this.line2;
            }
            case 3: {
                return this.line3;
            }
            case 4: {
                return this.line4;
            }
            case 5: {
                return this.line5;
            }
            case 6: {
                return this.line6;
            }
            case 7: {
                return this.line7;
            }
            case 8: {
                return this.line8;
            }
            case 9: {
                return this.line9;
            }
            case 10: {
                return this.line10;
            }
            case 11: {
                return this.line11;
            }
            case 12: {
                return this.line12;
            }
            case 13: {
                return this.line13;
            }
            case 14: {
                return this.line14;
            }
            case 15: {
                return this.line15;
            }
        }
        return this.line1;
    }

    private String getEntry(int line) {
        switch (line) {
            case 2: {
                return this.getColString("&2");
            }
            case 3: {
                return this.getColString("&3");
            }
            case 4: {
                return this.getColString("&4");
            }
            case 5: {
                return this.getColString("&5");
            }
            case 6: {
                return this.getColString("&6");
            }
            case 7: {
                return this.getColString("&7");
            }
            case 8: {
                return this.getColString("&8");
            }
            case 9: {
                return this.getColString("&9");
            }
            case 10: {
                return this.getColString("&0");
            }
            case 11: {
                return this.getColString("&a");
            }
            case 12: {
                return this.getColString("&b");
            }
            case 13: {
                return this.getColString("&c");
            }
            case 14: {
                return this.getColString("&d");
            }
            case 15: {
                return this.getColString("&e");
            }
        }
        return this.getColString("&1");
    }

    private String getColString(String string) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }
}

