/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.skboard.elements.effect;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import tk.shanebee.skboard.objects.Board;

@Name(value="Board - Line")
@Description(value={"set/delete a line in a player's scoreboard. Note: line 1 is bottom, line 15 is top."})
@Examples(value={"set line 1 of player's scoreboard to \"oooo I'm a line!!\"", "set line 15 of all player's scoreboards to \"I'm the top line!!!\"", "delete line 3 of player's scoreboard", "delete line 4 of all player's scoreboards"})
@Since(value="1.0.0")
public class EffBoardLine
extends Effect {
    private Expression<Number> line;
    private Expression<Player> players;
    private Expression<String> text;
    private boolean set;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.line = exprs[0];
        this.players = exprs[1];
        boolean bl = this.set = matchedPattern == 0;
        if (this.set) {
            this.text = exprs[2];
        }
        return true;
    }

    protected void execute(Event event) {
        Player[] players = (Player[])this.players.getArray(event);
        int line = ((Number)this.line.getSingle(event)).intValue();
        if (line > 15 || line < 1) {
            return;
        }
        String text = "";
        if (this.set) {
            text = (String)this.text.getSingle(event);
        }
        for (Player player : players) {
            Board board = Board.getBoard(player);
            if (board == null) continue;
            if (this.set) {
                board.setLine(line, text);
                continue;
            }
            board.deleteLine(line);
        }
    }

    public String toString(Event e, boolean d) {
        String set = this.set ? "set" : "delete";
        String string = this.set ? " to " + this.text.toString(e, d) : "";
        return set + " line " + this.line.toString(e, d) + " of " + this.players.toString(e, d) + " scoreboard" + string;
    }

    static {
        Skript.registerEffect(EffBoardLine.class, (String[])new String[]{"set line %number% of %players%'s [score]board[s] to %string%", "delete line %number% of %players%'s [score]board[s]"});
    }
}

