/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.skboard.elements.effect;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;
import tk.shanebee.skboard.objects.Board;

@Name(value="Board - Clear")
@Description(value={"Clear the scoreboard of a player"})
@Examples(value={"clear scoreboard of player", "clear scoreboards of all players"})
@Since(value="1.0.0")
public class EffBoardClear
extends Effect {
    private Expression<Player> players;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.players = exprs[0];
        return true;
    }

    protected void execute(Event event) {
        Player[] players;
        for (Player player : players = (Player[])this.players.getArray(event)) {
            Board board = Board.getBoard(player);
            if (board == null) continue;
            board.clearBoard();
        }
    }

    public String toString(@Nullable Event e, boolean d) {
        return "clear scoreboard of " + this.players.toString(e, d);
    }

    static {
        Skript.registerEffect(EffBoardClear.class, (String[])new String[]{"clear %players%'[s] [score]board[s]", "clear [score]board[s] of %players%"});
    }
}

