/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.skboard;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import tk.shanebee.skboard.listener.PlayerListener;
import tk.shanebee.skboard.objects.Board;

public class SkBoard
extends JavaPlugin {
    private static SkBoard instance;

    public void onEnable() {
        instance = this;
        PluginDescriptionFile desc = this.getDescription();
        if (Bukkit.getPluginManager().getPlugin("Skript") != null && Skript.isAcceptRegistrations()) {
            SkriptAddon addon = Skript.registerAddon((JavaPlugin)this);
            if (!Skript.isRunningMinecraft((int)1, (int)13)) {
                this.log("&cThis addon is not supported on your version.");
                this.log("&7SkBoard only supports 1.13+");
                Bukkit.getPluginManager().disablePlugin((Plugin)this);
                return;
            }
            try {
                addon.loadClasses("tk.shanebee.skboard", new String[]{"elements"});
            }
            catch (IOException e) {
                e.printStackTrace();
                Bukkit.getPluginManager().disablePlugin((Plugin)this);
                return;
            }
            this.log("&aSuccessfully enabled v" + desc.getVersion());
            if (desc.getVersion().contains("Beta")) {
                this.log("&eThis is a BETA build, things may not work as expected, please report any bugs on GitHub");
                this.log("&ehttps://github.com/ShaneBeee/SkBoard/issues");
            }
        } else {
            this.log("&cDependency Skript was not found, plugin disabling");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerListener(), (Plugin)this);
        for (Player player : Bukkit.getOnlinePlayers()) {
            Board.loadBoard(player);
        }
    }

    public void onDisable() {
        Board.clearBoards();
    }

    public static SkBoard getInstance() {
        return instance;
    }

    private void log(String message) {
        String pre = "&7[&bSkBoard&7] &r";
        Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(pre + message)));
    }
}

