/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.worldcreator.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.io.File;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="World Exists")
@Description(value={"Check if a world exists in your world directory."})
@Examples(value={"if world \"my-world\" exists:"})
@Since(value="1.8.0")
public class CondWorldExists
extends Condition {
    private Expression<String> world;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.world = exprs[0];
        this.setNegated(parseResult.mark == 1);
        return true;
    }

    public boolean check(@NotNull Event e) {
        return this.world.check(e, w -> {
            File file = new File(Bukkit.getWorldContainer(), (String)w);
            return file.exists() && file.isDirectory();
        }, this.isNegated());
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return String.format("%s%s", this.world.toString(e, d), this.isNegated() ? " does not exist" : " exists");
    }

    static {
        Skript.registerCondition(CondWorldExists.class, (String[])new String[]{"world %string% (0\u00a6exists|1\u00a6(does not|doesn't) exist)"});
    }
}

