/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.nbt.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.slot.Slot;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import tk.shanebee.bee.SkBee;
import tk.shanebee.bee.api.NBT.NBTCompound;
import tk.shanebee.bee.api.NBT.NBTContainer;
import tk.shanebee.bee.api.NBT.NBTCustomEntity;
import tk.shanebee.bee.api.NBT.NBTCustomTileEntity;
import tk.shanebee.bee.api.NBT.NBTItem;
import tk.shanebee.bee.api.NBTApi;

@Name(value="NBT - Compound of")
@Description(value={"Get the nbt compound of a block/entity/item/file. This is a more advanced version of NBT than just getting an NBT string ", "which allows for better manipulation. Optionally you can return a copy of the compound. This way you can modify it without ", "actually modifying the original compound, for example when grabbing the compound from an entity, modifying it and applying to ", "other entities. NBT from files and items will not be the original, but will be a copy."})
@Examples(value={"set {_n} to nbt compound of player's tool", "set {_nbt} to nbt compound of target entity", "set {_n} to nbt compound of \"{id:\"\"minecraft:diamond_sword\"\",tag:{Damage:0,Enchantments:[{id:\"\"minecraft:sharpness\"\",lvl:3s}]},Count:1b}\"", "set {_nbt} to nbt compound of file \"world/playerdata/some-uuid.dat\""})
@Since(value="1.6.0")
public class ExprNbtCompound
extends PropertyExpression<Object, NBTCompound> {
    private static final NBTApi NBT_API = SkBee.getPlugin().getNbtApi();
    private boolean copy;
    private boolean file;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        this.copy = parseResult.mark == 1;
        this.file = matchedPattern == 1;
        return true;
    }

    protected NBTCompound @NotNull [] get(@NotNull Event e, Object @NotNull [] source) {
        return (NBTCompound[])this.get(source, object -> {
            NBTCompound compound = null;
            if (object instanceof Block) {
                BlockState state = ((Block)object).getState();
                if (NBTApi.isTileEntity(state)) {
                    compound = new NBTCustomTileEntity(state);
                }
            } else if (object instanceof Entity) {
                compound = new NBTCustomEntity((Entity)object);
            } else if (object instanceof ItemType) {
                ItemStack stack = ((ItemType)object).getRandom();
                if (stack != null) {
                    compound = NBTItem.convertItemtoNBT(stack);
                }
            } else {
                if (object instanceof ItemStack) {
                    return NBTItem.convertItemtoNBT((ItemStack)object);
                }
                if (object instanceof Slot) {
                    ItemStack stack = ((Slot)object).getItem();
                    if (stack != null) {
                        compound = NBTItem.convertItemtoNBT(stack);
                    }
                } else if (object instanceof String) {
                    if (this.file) {
                        String fileNBT = NBT_API.getNBT(object, NBTApi.ObjectType.FILE);
                        if (fileNBT != null) {
                            compound = new NBTContainer(fileNBT);
                        }
                    } else if (NBTApi.validateNBT((String)object)) {
                        compound = new NBTContainer((String)object);
                    }
                }
            }
            if (compound != null) {
                if (this.copy) {
                    return new NBTContainer(compound.toString());
                }
                return compound;
            }
            return null;
        });
    }

    @NotNull
    public Class<? extends NBTCompound> getReturnType() {
        return NBTCompound.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "nbt compound from " + this.getExpr().toString(e, d);
    }

    static {
        Skript.registerExpression(ExprNbtCompound.class, NBTCompound.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"nbt compound [(1\u00a6copy)] (of|from) %blocks/entities/itemtypes/itemstacks/slots/strings%", "nbt compound (of|from) file[s] %strings%"});
    }
}

