/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.api.reflection;

import ch.njol.skript.Skript;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import org.bukkit.scoreboard.Team;
import tk.shanebee.bee.api.NBT.NBTCompound;
import tk.shanebee.bee.api.NBT.NBTContainer;
import tk.shanebee.bee.api.reflection.ReflectionUtils;

public class ChatReflection {
    private static final boolean LEGACY = !Skript.isRunningMinecraft((int)1, (int)13);
    private static final String VERSION = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
    private static final Class<?> CRAFT_CHAT_MESSAGE = ReflectionUtils.getOBCClass("util.CraftChatMessage");
    private static final Class<?> CRAFT_TEAM = ReflectionUtils.getOBCClass("scoreboard.CraftTeam");
    private static final Class<?> NMS_TEAM = ReflectionUtils.getNMSClass("ScoreboardTeam");
    private static final Class<?> NMS_ICHATBASE = ReflectionUtils.getNMSClass("IChatBaseComponent");
    private static final Method SET_PREFIX;
    private static final Method PREFIX_COMP_METHOD;

    public static String getPrettyNBT(NBTCompound compound, String split) {
        String prettyM = Ver.getPretty(split != null);
        if (prettyM == null) {
            return null;
        }
        Object nmsNBT = new NBTContainer(compound.toString()).getCompound();
        Class<?> iChatBaseComponent = ReflectionUtils.getNMSClass("IChatBaseComponent");
        Class<?> craftChatMessageClass = ReflectionUtils.getOBCClass("util.CraftChatMessage");
        try {
            Object prettyComponent;
            if (split != null) {
                Method prettyMethod = nmsNBT.getClass().getMethod(prettyM, String.class, Integer.TYPE);
                prettyComponent = prettyMethod.invoke(nmsNBT, split, 0);
            } else {
                Method prettyMethod = nmsNBT.getClass().getMethod(prettyM, new Class[0]);
                prettyComponent = prettyMethod.invoke(nmsNBT, new Object[0]);
            }
            assert (craftChatMessageClass != null);
            Method fromComponent = craftChatMessageClass.getMethod("fromComponent", iChatBaseComponent);
            return (String)fromComponent.invoke(craftChatMessageClass, prettyComponent);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setTeamPrefix(Team team, String prefix) {
        if (LEGACY || CRAFT_TEAM == null || PREFIX_COMP_METHOD == null || SET_PREFIX == null) {
            team.setPrefix("");
            team.setSuffix("");
            return;
        }
        try {
            Object nmsTeam = ReflectionUtils.getField("team", CRAFT_TEAM, team);
            Object prefixComp = PREFIX_COMP_METHOD.invoke(null, prefix);
            SET_PREFIX.invoke(nmsTeam, prefixComp);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    static {
        Method PREFIX_COMP_METHOD1 = null;
        Method SET_PREFIX1 = null;
        if (CRAFT_TEAM != null && NMS_TEAM != null && CRAFT_CHAT_MESSAGE != null) {
            try {
                SET_PREFIX1 = NMS_TEAM.getDeclaredMethod("setPrefix", NMS_ICHATBASE);
                PREFIX_COMP_METHOD1 = CRAFT_CHAT_MESSAGE.getDeclaredMethod("fromStringOrNull", String.class);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        PREFIX_COMP_METHOD = PREFIX_COMP_METHOD1;
        SET_PREFIX = SET_PREFIX1;
    }

    private static enum Ver {
        V_1_13_R2("v1_13_R2", "k", "a"),
        V_1_14_R1("v1_14_R1", "k", "a"),
        V_1_15_R1("v1_15_R1", "l", "a"),
        V_1_16_R1("v1_16_R1", "l", "a"),
        V_1_16_R2("v1_16_R2", "l", "a"),
        V_1_16_R3("v1_16_R3", "l", "a");

        private final String version;
        private final String pretty;
        private final String prettySplit;

        private Ver(String version, String pretty, String prettySplit) {
            this.version = version;
            this.pretty = pretty;
            this.prettySplit = prettySplit;
        }

        private static String getPretty(boolean split) {
            for (Ver value : Ver.values()) {
                if (!value.version.equalsIgnoreCase(VERSION)) continue;
                if (split) {
                    return value.prettySplit;
                }
                return value.pretty;
            }
            return null;
        }
    }
}

