/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.api.Structure.core.block;

import tk.shanebee.bee.api.Structure.api.block.StructureBlockDataAbstract;
import tk.shanebee.bee.api.Structure.api.block.StructureBlockLoadAbstract;
import tk.shanebee.bee.api.Structure.api.block.StructureBlockSaveAbstract;
import tk.shanebee.bee.api.Structure.api.entity.Position;
import tk.shanebee.bee.api.Structure.api.entity.StructureLoaderAbstract;
import tk.shanebee.bee.api.Structure.api.entity.StructureSaverAbstract;
import tk.shanebee.bee.api.Structure.api.enumeration.StructureMirror;
import tk.shanebee.bee.api.Structure.api.enumeration.StructureMode;
import tk.shanebee.bee.api.Structure.api.enumeration.StructureRotation;
import tk.shanebee.bee.api.Structure.api.service.ProxyService;
import tk.shanebee.bee.api.Structure.lib.org.jetbrains.annotations.NotNull;
import tk.shanebee.bee.api.Structure.lib.org.jetbrains.annotations.Nullable;

public class StructureBlockAbstractImpl<L, V>
implements StructureBlockDataAbstract,
StructureBlockSaveAbstract<L, V>,
StructureBlockLoadAbstract<L, V> {
    private final ProxyService proxyService;
    private final StructureLoaderAbstract<L, V> loader;
    private final StructureSaverAbstract<L, V> saver;
    private StructureMode mode = StructureMode.CORNER;
    private boolean boundingBox = true;
    private String saveName;
    private boolean invisibleBlocks = false;
    private String metaData;

    public StructureBlockAbstractImpl(ProxyService proxyService, StructureLoaderAbstract<L, V> loader, StructureSaverAbstract<L, V> saver) {
        this.proxyService = proxyService;
        this.loader = loader;
        this.saver = saver;
    }

    @Override
    public void setStructureMode(@NotNull StructureMode structureMode) {
        this.mode = structureMode;
    }

    @Override
    @NotNull
    public StructureMode getStructureMode() {
        return this.mode;
    }

    @Override
    public void setMirrorType(@NotNull StructureMirror mirrorType) {
        this.loader.mirror(mirrorType);
    }

    @Override
    public void setRotationType(@NotNull StructureRotation rotation) {
        this.loader.rotation(rotation);
    }

    @Override
    @NotNull
    public StructureRotation getRotationType() {
        return this.loader.getRotationType();
    }

    @Override
    @NotNull
    public StructureMirror getMirrorType() {
        return this.loader.getMirrorType();
    }

    @Override
    public void setBoundingBoxVisible(boolean visible) {
        this.boundingBox = visible;
    }

    @Override
    public boolean isBoundingBoxVisible() {
        return this.boundingBox;
    }

    @Override
    public void setIntegrity(float integrity) {
        this.loader.integrity(integrity);
    }

    @Override
    public float getIntegrity() {
        return this.loader.getIntegrity();
    }

    @Override
    public void setSeed(long seed) {
        this.loader.seed(seed);
    }

    @Override
    public long getSeed() {
        return this.loader.getSeed();
    }

    @Override
    public void setAuthor(@Nullable String author) {
        this.saver.author(author);
    }

    @Override
    @Nullable
    public String getAuthor() {
        return this.saver.getAuthor();
    }

    @Override
    public void setStructureLocation(@Nullable L location) {
        this.loader.at(location);
        this.saver.at(location);
    }

    @Override
    @Nullable
    public L getStructureLocation() {
        return this.loader.getLocation();
    }

    @Override
    public void setIncludeEntities(boolean flag) {
        this.saver.includeEntities(flag);
        this.loader.includeEntities(flag);
    }

    @Override
    public boolean isIncludeEntitiesEnabled() {
        return this.saver.isIncludeEntitiesEnabled();
    }

    @Override
    public void setSizeX(int sizeX) {
        this.saver.sizeX(sizeX);
    }

    @Override
    public void setSizeY(int sizeY) {
        this.saver.sizeY(sizeY);
    }

    @Override
    public void setSizeZ(int sizeZ) {
        this.saver.sizeZ(sizeZ);
    }

    @Override
    public int getSizeX() {
        Position vector = this.proxyService.toPosition(this.saver.getOffset());
        if (vector == null) {
            return 0;
        }
        return (int)vector.getX();
    }

    @Override
    public int getSizeY() {
        Position vector = this.proxyService.toPosition(this.saver.getOffset());
        if (vector == null) {
            return 0;
        }
        return (int)vector.getY();
    }

    @Override
    public int getSizeZ() {
        Position vector = this.proxyService.toPosition(this.saver.getOffset());
        if (vector == null) {
            return 0;
        }
        return (int)vector.getZ();
    }

    @Override
    public void setSaveName(@Nullable String name) {
        this.saveName = name;
    }

    @Override
    @Nullable
    public String getSaveName() {
        return this.saveName;
    }

    @Override
    public void setBlockNameMetaData(@Nullable String blockNameMetaData) {
        this.metaData = blockNameMetaData;
    }

    @Override
    @Nullable
    public String getBlockNameMetaData() {
        return this.metaData;
    }

    @Override
    public void setInvisibleBlocksEnabled(boolean flag) {
        this.invisibleBlocks = flag;
    }

    @Override
    public boolean isInvisibleBlocksEnabled() {
        return this.invisibleBlocks;
    }

    @Override
    @NotNull
    public StructureSaverAbstract<L, V> saveStructure() {
        return this.saver;
    }

    @Override
    @NotNull
    public StructureLoaderAbstract<L, V> loadStructure() {
        return this.loader;
    }
}

