/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.api;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.util.slot.Slot;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.TileState;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tk.shanebee.bee.SkBee;
import tk.shanebee.bee.api.NBT.NBTCompound;
import tk.shanebee.bee.api.NBT.NBTCompoundList;
import tk.shanebee.bee.api.NBT.NBTContainer;
import tk.shanebee.bee.api.NBT.NBTCustomEntity;
import tk.shanebee.bee.api.NBT.NBTCustomTileEntity;
import tk.shanebee.bee.api.NBT.NBTEntity;
import tk.shanebee.bee.api.NBT.NBTFile;
import tk.shanebee.bee.api.NBT.NBTItem;
import tk.shanebee.bee.api.NBT.NBTList;
import tk.shanebee.bee.api.NBT.NBTTileEntity;
import tk.shanebee.bee.api.NBT.NBTType;
import tk.shanebee.bee.api.NBT.NbtApiException;
import tk.shanebee.bee.api.reflection.SkReflection;
import tk.shanebee.bee.api.util.MathUtil;
import tk.shanebee.bee.api.util.Util;
import tk.shanebee.bee.config.Config;

public class NBTApi {
    public static final boolean HAS_PERSISTENCE = Skript.isRunningMinecraft((int)1, (int)14);
    private final Config CONFIG = SkBee.getPlugin().getPluginConfig();

    public static boolean validateNBT(String nbtString) {
        if (nbtString == null) {
            return false;
        }
        try {
            new NBTContainer(nbtString);
        }
        catch (Exception ex) {
            NBTApi.sendError(nbtString, ex);
            return false;
        }
        return true;
    }

    private static void sendError(String error, Exception exception) {
        Util.skriptError("&cInvalid NBT: &b" + error + "&c");
        if (exception == null) {
            return;
        }
        if (SkBee.getPlugin().getPluginConfig().SETTINGS_DEBUG) {
            exception.printStackTrace();
        } else {
            String[] split;
            String cause = exception.getCause().getCause().getCause().toString();
            if (cause.contains("CommandSyntaxException") && (split = cause.split("CommandSyntaxException: ")).length > 1) {
                Util.skriptError("&cCause: &e" + split[1]);
            }
        }
    }

    public void forceLoadNBT() {
        Util.log("&aLoading NBTApi...");
        NBTItem loadingItem = new NBTItem(new ItemStack(Material.STONE));
        loadingItem.mergeCompound(new NBTContainer("{}"));
        Util.log("&aSuccessfully loaded NBTApi!");
    }

    private File getFile(String fileName) {
        File file = new File(fileName = !fileName.endsWith(".dat") && !fileName.endsWith(".nbt") ? fileName + ".dat" : fileName);
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    @Nullable
    public Object addNBT(@NotNull Object object, @NotNull String value, @NotNull ObjectType type) {
        if (!type.isAssignableFrom(object, this.CONFIG.SETTINGS_DEBUG)) {
            return null;
        }
        if (!NBTApi.validateNBT(value)) {
            return null;
        }
        switch (type) {
            case FILE: {
                File file = this.getFile((String)object);
                if (file == null) {
                    return null;
                }
                try {
                    NBTFile nbtFile = new NBTFile(file);
                    nbtFile.mergeCompound(new NBTContainer(value));
                    nbtFile.save();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return null;
            }
            case ITEM_STACK: {
                ItemStack itemStack = (ItemStack)object;
                if (itemStack.getType() == Material.AIR) {
                    return itemStack;
                }
                NBTItem item = new NBTItem(itemStack);
                item.mergeCompound(new NBTContainer(value));
                ItemMeta meta = item.getItem().getItemMeta();
                if (meta == null) {
                    return itemStack;
                }
                itemStack.setItemMeta(item.getItem().getItemMeta());
                return item.getItem();
            }
            case ITEM_TYPE: {
                ItemStack stack = ((ItemType)object).getRandom();
                if (stack == null || stack.getType() == Material.AIR) {
                    return object;
                }
                NBTItem nbtItemType = new NBTItem(stack);
                nbtItemType.mergeCompound(new NBTContainer(value));
                ItemMeta itemMeta = nbtItemType.getItem().getItemMeta();
                if (itemMeta == null) {
                    return object;
                }
                SkReflection.setMeta((ItemType)object, nbtItemType.getItem().getItemMeta());
                return object;
            }
            case SLOT: {
                ItemStack slotItemStack = ((Slot)object).getItem();
                if (slotItemStack != null && slotItemStack.getType() != Material.AIR) {
                    ((Slot)object).setItem((ItemStack)this.addNBT(slotItemStack, value, ObjectType.ITEM_STACK));
                }
                return object;
            }
            case ENTITY: {
                NBTCustomEntity nbtEntity = new NBTCustomEntity((Entity)object);
                NBTContainer nbtCompound = new NBTContainer(value);
                if (nbtCompound.hasKey("custom").booleanValue()) {
                    NBTCompound custom = nbtEntity.getCustomNBT();
                    custom.mergeCompound(nbtCompound.getCompound("custom"));
                    nbtEntity.setCustomNBT(custom);
                }
                nbtEntity.mergeCompound(nbtCompound);
                return object;
            }
            case BLOCK: {
                BlockState blockState = ((Block)object).getState();
                if (NBTApi.isTileEntity(blockState)) {
                    NBTCustomTileEntity nbtBlock = new NBTCustomTileEntity(blockState);
                    NBTContainer updated = new NBTContainer(value);
                    if (updated.hasKey("custom").booleanValue()) {
                        NBTCompound custom = nbtBlock.getCustomNBT();
                        custom.mergeCompound(updated.getCompound("custom"));
                        nbtBlock.setCustomNBT(custom);
                    }
                    nbtBlock.mergeCompound(updated);
                }
                return object;
            }
        }
        if (this.CONFIG.SETTINGS_DEBUG) {
            throw new IllegalArgumentException("Unsupported ObjectType: " + (Object)((Object)type));
        }
        return null;
    }

    @Nullable
    public Object setNBT(@NotNull Object object, @NotNull String value, @NotNull ObjectType type) {
        if (!type.isAssignableFrom(object, this.CONFIG.SETTINGS_DEBUG)) {
            return null;
        }
        if (!NBTApi.validateNBT(value)) {
            return null;
        }
        switch (type) {
            case FILE: {
                return this.addNBT(object, value, ObjectType.FILE);
            }
            case ITEM_STACK: {
                ItemStack stack = new ItemStack(((ItemStack)object).getType());
                NBTItem nbtItemStack = new NBTItem(stack);
                nbtItemStack.mergeCompound(new NBTContainer(value));
                ((ItemStack)object).setItemMeta(nbtItemStack.getItem().getItemMeta());
                return object;
            }
            case ITEM_TYPE: {
                ItemStack itemStack = new ItemStack(((ItemType)object).getMaterial());
                NBTItem nbtItemType = new NBTItem(itemStack);
                nbtItemType.mergeCompound(new NBTContainer(value));
                SkReflection.setMeta((ItemType)object, nbtItemType.getItem().getItemMeta());
                return object;
            }
            case SLOT: {
                ItemStack slotItemStack = ((Slot)object).getItem();
                if (slotItemStack != null) {
                    ((Slot)object).setItem((ItemStack)this.setNBT(slotItemStack, value, ObjectType.ITEM_STACK));
                }
                return object;
            }
            case ENTITY: {
                return this.addNBT(object, value, ObjectType.ENTITY);
            }
            case BLOCK: {
                return this.addNBT(object, value, ObjectType.BLOCK);
            }
        }
        if (this.CONFIG.SETTINGS_DEBUG) {
            throw new IllegalArgumentException("Unsupported ObjectType: " + (Object)((Object)type));
        }
        return null;
    }

    @Nullable
    public String getNBT(@NotNull Object object, @NotNull ObjectType type) {
        if (!type.isAssignableFrom(object, this.CONFIG.SETTINGS_DEBUG)) {
            return null;
        }
        switch (type) {
            case FILE: {
                File file = this.getFile((String)object);
                if (file == null) {
                    return null;
                }
                NBTFile fileNBT = null;
                try {
                    fileNBT = new NBTFile(file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (fileNBT == null) {
                    return null;
                }
                return fileNBT.toString();
            }
            case ITEM_STACK: {
                ItemStack itemStack = (ItemStack)object;
                if (itemStack.getType() == Material.AIR) {
                    return null;
                }
                NBTItem item = new NBTItem(itemStack);
                return item.toString();
            }
            case ITEM_STACK_FULL: {
                return NBTItem.convertItemtoNBT((ItemStack)object).toString();
            }
            case ITEM_TYPE: {
                ItemStack itemTypeStack = ((ItemType)object).getRandom();
                if (itemTypeStack == null) {
                    return null;
                }
                return this.getNBT(itemTypeStack, ObjectType.ITEM_STACK);
            }
            case ITEM_TYPE_FULL: {
                ItemStack itemTypeStackFull = ((ItemType)object).getRandom();
                if (itemTypeStackFull == null) {
                    return null;
                }
                return this.getNBT(itemTypeStackFull, ObjectType.ITEM_STACK_FULL);
            }
            case SLOT: {
                ItemStack slotItemStack = ((Slot)object).getItem();
                if (slotItemStack == null) {
                    return null;
                }
                return this.getNBT(slotItemStack, ObjectType.ITEM_STACK);
            }
            case SLOT_FULL: {
                ItemStack slotItemStackFull = ((Slot)object).getItem();
                if (slotItemStackFull == null) {
                    return null;
                }
                return this.getNBT(slotItemStackFull, ObjectType.ITEM_STACK_FULL);
            }
            case ENTITY: {
                Entity entity = (Entity)object;
                NBTEntity nbtEntity = new NBTEntity(entity);
                return nbtEntity.toString();
            }
            case BLOCK: {
                NBTTileEntity tile = new NBTTileEntity(((Block)object).getState());
                try {
                    return tile.getCompound().toString();
                }
                catch (NbtApiException ignore) {
                    return null;
                }
            }
        }
        if (this.CONFIG.SETTINGS_DEBUG) {
            throw new IllegalArgumentException("Unsupported ObjectType: " + (Object)((Object)type));
        }
        return null;
    }

    public ItemType getItemTypeFromNBT(String nbt) {
        if (!NBTApi.validateNBT(nbt)) {
            return null;
        }
        return new ItemType(this.getItemStackFromNBT(nbt));
    }

    public ItemStack getItemStackFromNBT(String nbt) {
        if (!NBTApi.validateNBT(nbt)) {
            return null;
        }
        NBTContainer container = new NBTContainer(nbt);
        return NBTItem.convertNBTtoItem(container);
    }

    public ItemType getItemTypeFromNBT(NBTCompound nbt) {
        return new ItemType(this.getItemStackFromNBT(nbt));
    }

    public ItemStack getItemStackFromNBT(NBTCompound nbt) {
        return NBTItem.convertNBTtoItem(nbt);
    }

    public void deleteTag(@NotNull String tag, @NotNull NBTCompound nbtCompound) {
        NBTCompound compound = nbtCompound;
        String key = tag;
        if (tag.contains(";")) {
            String[] splits = tag.split(";");
            for (int i = 0; i < splits.length - 1; ++i) {
                if (!compound.hasKey(splits[i]).booleanValue()) continue;
                compound = compound.getCompound(splits[i]);
            }
            key = splits[splits.length - 1];
        }
        compound.removeKey(key);
    }

    public void setTag(@NotNull String tag, @NotNull NBTCompound nbtCompound, @NotNull Object[] object) {
        NBTCompound compound = nbtCompound;
        String key = tag;
        if (tag.contains(";")) {
            String[] splits = tag.split(";");
            for (int i = 0; i < splits.length - 1; ++i) {
                if (!compound.hasKey(splits[i]).booleanValue()) continue;
                compound = compound.getCompound(splits[i]);
            }
            key = splits[splits.length - 1];
        }
        boolean custom = compound.hasKey(key) == false;
        boolean isSingle = object.length == 1;
        NBTType type = compound.getType(key);
        Object singleObject = object[0];
        if (singleObject instanceof String && (type == NBTType.NBTTagString || custom && isSingle)) {
            compound.setString(key, (String)singleObject);
        } else if (singleObject instanceof Number && (type == NBTType.NBTTagByte || custom && isSingle && MathUtil.isByte(singleObject))) {
            compound.setByte(key, ((Number)singleObject).byteValue());
        } else if (singleObject instanceof Number && (type == NBTType.NBTTagShort || custom && isSingle && MathUtil.isShort(singleObject))) {
            compound.setShort(key, ((Number)singleObject).shortValue());
        } else if (singleObject instanceof Number && (type == NBTType.NBTTagInt || custom && isSingle && MathUtil.isInt(singleObject))) {
            compound.setInteger(key, ((Number)singleObject).intValue());
        } else if (singleObject instanceof Number && (type == NBTType.NBTTagLong || custom && isSingle && singleObject instanceof Long)) {
            compound.setLong(key, ((Number)singleObject).longValue());
        } else if (singleObject instanceof Number && (type == NBTType.NBTTagFloat || custom && isSingle && MathUtil.isFloat(singleObject))) {
            compound.setFloat(key, Float.valueOf(((Number)singleObject).floatValue()));
        } else if (singleObject instanceof Number && (type == NBTType.NBTTagDouble || custom && isSingle && singleObject instanceof Double)) {
            compound.setDouble(key, ((Number)singleObject).doubleValue());
        } else if ((type == NBTType.NBTTagCompound || custom && isSingle) && singleObject instanceof NBTCompound) {
            NBTCompound comp;
            if (custom) {
                comp = compound.addCompound(key);
            } else {
                comp = compound.getCompound(key);
                for (String compKey : comp.getKeys()) {
                    comp.removeKey(compKey);
                }
            }
            comp.mergeCompound((NBTCompound)singleObject);
        } else if (type == NBTType.NBTTagList || custom && !isSingle && !(object instanceof Integer[]) && !(object instanceof Byte[])) {
            if (MathUtil.isInt(singleObject)) {
                NBTList<Integer> list = compound.getIntegerList(key);
                list.clear();
                for (Object o : object) {
                    list.add(((Number)o).intValue());
                }
            } else if (singleObject instanceof Long) {
                NBTList<Long> list = compound.getLongList(key);
                list.clear();
                for (Object o : object) {
                    list.add(((Number)o).longValue());
                }
            } else if (MathUtil.isFloat(singleObject)) {
                NBTList<Float> list = compound.getFloatList(key);
                list.clear();
                for (Object o : object) {
                    list.add(Float.valueOf(((Number)o).floatValue()));
                }
            } else if (singleObject instanceof Double) {
                NBTList<Double> list = compound.getDoubleList(key);
                list.clear();
                for (Object o : object) {
                    list.add(((Number)o).doubleValue());
                }
            } else if (singleObject instanceof NBTCompound) {
                NBTCompoundList list = compound.getCompoundList(key);
                list.clear();
                for (Object o : object) {
                    list.addCompound((NBTCompound)o);
                }
            } else if (singleObject instanceof String) {
                NBTList<String> list = compound.getStringList(key);
                list.clear();
                for (Object o : object) {
                    list.add((String)o);
                }
            }
        } else if (singleObject instanceof Number && (type == NBTType.NBTTagByteArray || object instanceof Byte[])) {
            byte[] n = new byte[object.length];
            for (int i = 0; i < object.length; ++i) {
                n[i] = ((Number)object[i]).byteValue();
            }
            compound.setByteArray(key, n);
        } else if (singleObject instanceof Number && (type == NBTType.NBTTagIntArray || object instanceof Integer[])) {
            int[] n = new int[object.length];
            for (int i = 0; i < object.length; ++i) {
                n[i] = ((Number)object[i]).intValue();
            }
            compound.setIntArray(key, n);
        } else {
            Util.skriptError("Other-> KEY: " + key + " VALUE: " + singleObject + " VALUE-CLASS: " + object.getClass() + " TYPE: " + (Object)((Object)type));
        }
    }

    public Object getTag(String tag, String nbt) {
        if (nbt == null) {
            return null;
        }
        NBTContainer compound = new NBTContainer(nbt);
        NBTType type = compound.getType(tag);
        switch (type) {
            case NBTTagString: {
                return compound.getString(tag);
            }
            case NBTTagInt: {
                return compound.getInteger(tag);
            }
            case NBTTagIntArray: {
                UUID uuid;
                if (compound.getIntArray(tag).length == 4 && (uuid = compound.getUUID(tag)) != null) {
                    return uuid;
                }
                ArrayList<Integer> intArray = new ArrayList<Integer>();
                for (int i : compound.getIntArray(tag)) {
                    intArray.add(i);
                }
                return intArray;
            }
            case NBTTagFloat: {
                return compound.getFloat(tag);
            }
            case NBTTagShort: {
                return compound.getShort(tag);
            }
            case NBTTagDouble: {
                return compound.getDouble(tag);
            }
            case NBTTagEnd: {
                return null;
            }
            case NBTTagLong: {
                return compound.getLong(tag);
            }
            case NBTTagByte: {
                return compound.getByte(tag);
            }
            case NBTTagByteArray: {
                return compound.getByteArray(tag);
            }
            case NBTTagCompound: {
                return compound.getCompound(tag);
            }
            case NBTTagList: {
                ArrayList<Object> list = new ArrayList<Object>();
                list.addAll(compound.getCompoundList(tag));
                list.addAll(compound.getDoubleList(tag));
                list.addAll(compound.getFloatList(tag));
                list.addAll(compound.getIntegerList(tag));
                list.addAll(compound.getStringList(tag));
                list.addAll(compound.getLongList(tag));
                return list;
            }
        }
        if (this.CONFIG.SETTINGS_DEBUG) {
            throw new IllegalArgumentException("Unknown tag type, please let the dev know -> type: " + type.toString());
        }
        return null;
    }

    public static boolean isTileEntity(BlockState blockState) {
        if (HAS_PERSISTENCE) {
            return blockState instanceof TileState;
        }
        return !blockState.getClass().getName().endsWith("CraftBlockState");
    }

    public static enum ObjectType {
        ITEM_TYPE(ItemType.class),
        ITEM_TYPE_FULL(ItemType.class),
        ITEM_STACK(ItemStack.class),
        ITEM_STACK_FULL(ItemStack.class),
        SLOT(Slot.class),
        SLOT_FULL(Slot.class),
        ENTITY(Entity.class),
        BLOCK(Block.class),
        FILE(String.class);

        Class<?> cl;

        private ObjectType(Class<?> classType) {
            this.cl = classType;
        }

        public boolean isAssignableFrom(Object object, boolean debug) {
            if (this.cl.isAssignableFrom(object.getClass())) {
                return true;
            }
            if (debug) {
                throw new IllegalArgumentException("Object is not assignable from ObjectType:\n\tObject: " + object + " = " + object.getClass() + "\n\tObjectType: " + (Object)((Object)this) + "\n\tAssignableFrom: " + this.cl);
            }
            return false;
        }
    }
}

