/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import tk.shanebee.bee.api.NBT.utils.MinecraftVersion;
import tk.shanebee.bee.api.NBTApi;
import tk.shanebee.bee.api.Structure.bukkit.service.ProxyServiceImpl;
import tk.shanebee.bee.api.listener.BoundBorderListener;
import tk.shanebee.bee.api.listener.EntityListener;
import tk.shanebee.bee.api.paperlib.PaperLib;
import tk.shanebee.bee.api.util.LoggerBee;
import tk.shanebee.bee.api.util.Util;
import tk.shanebee.bee.api.virtualfurnace.api.VirtualFurnaceAPI;
import tk.shanebee.bee.config.Config;
import tk.shanebee.bee.elements.board.listener.PlayerBoardListener;
import tk.shanebee.bee.elements.board.objects.Board;
import tk.shanebee.bee.elements.bound.config.BoundConfig;
import tk.shanebee.bee.elements.bound.objects.Bound;
import tk.shanebee.bee.elements.virtualfurnace.listener.VirtualFurnaceListener;
import tk.shanebee.bee.elements.worldcreator.objects.BeeWorldConfig;
import tk.shanebee.bee.metrics.Metrics;

public class SkBee
extends JavaPlugin {
    private static SkBee instance;
    private NBTApi nbtApi;
    private PluginManager pm;
    private Config config;
    private BoundConfig boundConfig = null;
    private SkriptAddon addon;
    private VirtualFurnaceAPI virtualFurnaceAPI;
    private BeeWorldConfig beeWorldConfig;

    public void onEnable() {
        long start = System.currentTimeMillis();
        instance = this;
        this.config = new Config(this);
        this.nbtApi = new NBTApi();
        MinecraftVersion.replaceLogger(LoggerBee.getLogger());
        this.pm = Bukkit.getPluginManager();
        PluginDescriptionFile desc = this.getDescription();
        Plugin SKRIPT = this.pm.getPlugin("Skript");
        if (SKRIPT != null && SKRIPT.isEnabled() && Skript.isAcceptRegistrations()) {
            this.addon = Skript.registerAddon((JavaPlugin)this);
            this.addon.setLanguageFileDirectory("lang");
            this.loadNBTElements();
            this.loadRecipeElements();
            this.loadBoardElements();
            this.loadBoundElements();
            this.loadTextElements();
            this.loadPathElements();
            this.loadStructureElements();
            this.loadOtherElements();
            this.loadVirtualFurnaceElements();
            this.loadWorldCreatorElements();
            if (desc.getVersion().contains("Beta")) {
                Util.log("&eThis is a BETA build, things may not work as expected, please report any bugs on GitHub");
                Util.log("&ehttps://github.com/ShaneBeee/SkBee/issues");
            }
        } else {
            Util.log("&cDependency Skript was not found, plugin disabling");
            this.pm.disablePlugin((Plugin)this);
            return;
        }
        PaperLib.suggestPaper((Plugin)this);
        this.loadMetrics();
        Util.log("&aSuccessfully enabled v%s&7 in &b%.2f seconds", desc.getVersion(), Float.valueOf((float)(System.currentTimeMillis() - start) / 1000.0f));
        if (this.beeWorldConfig != null && this.config.AUTO_LOAD_WORLDS) {
            this.beeWorldConfig.loadCustomWorlds();
        }
    }

    private void loadNBTElements() {
        if (!this.config.ELEMENTS_NBT) {
            Util.log("&5NBT Elements &cdisabled via config");
            return;
        }
        try {
            this.nbtApi.forceLoadNBT();
        }
        catch (Exception ignore) {
            String ver = Skript.getMinecraftVersion().toString();
            Util.log("&5NBT Elements &cDISABLED!");
            Util.log(" - Your server version [&b" + ver + "&7] is not currently supported by the NBT-API");
            Util.log(" - This is not a bug!");
            Util.log(" - NBT elements will resume once the API is updated to work with [&b" + ver + "&7]");
            return;
        }
        try {
            this.addon.loadClasses("tk.shanebee.bee.elements.nbt", new String[0]);
            Util.log("&5NBT Elements &asuccessfully loaded");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.pm.disablePlugin((Plugin)this);
        }
    }

    private void loadRecipeElements() {
        if (Skript.isRunningMinecraft((int)1, (int)13)) {
            if (!this.config.ELEMENTS_RECIPE) {
                Util.log("&5Recipe Elements &cdisabled via config");
                return;
            }
            try {
                this.addon.loadClasses("tk.shanebee.bee.elements.recipe", new String[0]);
                Util.log("&5Recipe Elements &asuccessfully loaded");
            }
            catch (IOException ex) {
                ex.printStackTrace();
                this.pm.disablePlugin((Plugin)this);
            }
        } else {
            Util.log("&5Recipe Elements &cdisabled");
            Util.log("&7 - Recipe elements are only available on 1.13+");
        }
    }

    private void loadBoardElements() {
        if (Skript.isRunningMinecraft((int)1, (int)8, (int)8)) {
            if (!this.config.ELEMENTS_BOARD) {
                Util.log("&5Scoreboard Elements &cdisabled via config");
                return;
            }
            try {
                this.addon.loadClasses("tk.shanebee.bee.elements.board", new String[0]);
                this.pm.registerEvents((Listener)new PlayerBoardListener(), (Plugin)this);
                Bukkit.getOnlinePlayers().forEach(Board::createBoard);
                Util.log("&5Scoreboard Elements &asuccessfully loaded");
            }
            catch (IOException ex) {
                ex.printStackTrace();
                this.pm.disablePlugin((Plugin)this);
            }
        } else {
            Util.log("&5Scoreboard Elements &cdisabled");
            Util.log("&7 - Scoreboard elements are only available on 1.8.8+");
        }
    }

    private void loadBoundElements() {
        if (!this.config.ELEMENTS_BOUND) {
            Util.log("&5Bound Elements &cdisabled via config");
            return;
        }
        try {
            this.boundConfig = new BoundConfig(this);
            this.pm.registerEvents((Listener)new BoundBorderListener(this), (Plugin)this);
            this.addon.loadClasses("tk.shanebee.bee.elements.bound", new String[0]);
            Util.log("&5Bound Elements &asuccessfully loaded");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.pm.disablePlugin((Plugin)this);
        }
    }

    private void loadTextElements() {
        if (!this.config.ELEMENTS_TEXT_COMPONENT) {
            Util.log("&5Text Component Elements &cdisabled via config");
            return;
        }
        try {
            this.addon.loadClasses("tk.shanebee.bee.elements.text", new String[0]);
            Util.log("&5Text Component Elements &asuccessfully loaded");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.pm.disablePlugin((Plugin)this);
        }
    }

    private void loadPathElements() {
        if (Skript.classExists((String)"com.destroystokyo.paper.entity.Pathfinder")) {
            if (!this.config.ELEMENTS_PATHFINDING) {
                Util.log("&5Pathfinding Elements &cdisabled via config");
                return;
            }
            try {
                this.addon.loadClasses("tk.shanebee.bee.elements.path", new String[0]);
                Util.log("&5Pathfinding Elements &asuccessfully loaded");
            }
            catch (IOException ex) {
                ex.printStackTrace();
                this.pm.disablePlugin((Plugin)this);
            }
        } else {
            Util.log("&5Pathfinding &cdisabled");
            Util.log("&7 - Pathfinding elements are only available on Paper 1.13+");
        }
    }

    private void loadStructureElements() {
        if (Skript.isRunningMinecraft((int)1, (int)9, (int)4)) {
            if (!this.config.ELEMENTS_STRUCTURE) {
                Util.log("&5Structure Elements &cdisabled via config");
                return;
            }
            ProxyServiceImpl impl = new ProxyServiceImpl((Plugin)this);
            if (impl.getServerVersion() == null) {
                String ver = Skript.getMinecraftVersion().toString();
                Util.log("&5Structure Elements &cDISABLED!");
                Util.log(" - Your server version [&b" + ver + "&7] is not currently supported by the StructureBlock API");
                Util.log(" - This is not a bug!");
                Util.log(" - Structure elements will resume once the API is updated to work with [&b" + ver + "&7]");
                return;
            }
            try {
                this.addon.loadClasses("tk.shanebee.bee.elements.structure", new String[0]);
                Util.log("&5Structure Elements &asuccessfully loaded");
            }
            catch (IOException ex) {
                ex.printStackTrace();
                this.pm.disablePlugin((Plugin)this);
            }
        } else {
            Util.log("&5Structure Elements &cdisabled");
            Util.log("&7 - Structure elements are only available on 1.9.4+");
        }
    }

    private void loadVirtualFurnaceElements() {
        if (Skript.classExists((String)"org.bukkit.persistence.PersistentDataContainer")) {
            if (!this.config.ELEMENTS_VIRTUAL_FURNACE) {
                Util.log("&5Virtual Furnace Elements &cdisabled via config");
                return;
            }
            try {
                this.virtualFurnaceAPI = new VirtualFurnaceAPI(this, true);
                this.pm.registerEvents((Listener)new VirtualFurnaceListener(), (Plugin)this);
                this.addon.loadClasses("tk.shanebee.bee.elements.virtualfurnace", new String[0]);
                Util.log("&5Virtual Furnace Elements &asuccessfully loaded");
            }
            catch (IOException e) {
                e.printStackTrace();
                this.pm.disablePlugin((Plugin)this);
            }
        } else {
            Util.log("&5Virtual Furnace Elements &cdisabled");
            Util.log("&7 - Virtual Furnace elements are only available on 1.13+");
        }
    }

    private void loadOtherElements() {
        try {
            this.pm.registerEvents((Listener)new EntityListener(), (Plugin)this);
            this.addon.loadClasses("tk.shanebee.bee.elements.other", new String[0]);
            Util.log("&5Other Elements &asuccessfully loaded");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.pm.disablePlugin((Plugin)this);
        }
    }

    private void loadWorldCreatorElements() {
        if (!this.config.ELEMENTS_WORLD_CREATOR) {
            Util.log("&5World Creator Elements &cdisabled via config");
            return;
        }
        try {
            this.beeWorldConfig = new BeeWorldConfig(this);
            this.addon.loadClasses("tk.shanebee.bee.elements.worldcreator", new String[0]);
            Util.log("&5World Creator Elements &asuccessfully loaded");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.pm.disablePlugin((Plugin)this);
        }
    }

    private void loadMetrics() {
        Metrics metrics = new Metrics((Plugin)this, 6719);
        metrics.addCustomChart(new Metrics.SimplePie("skript_version", () -> Skript.getVersion().toString()));
    }

    public void onDisable() {
        if (this.virtualFurnaceAPI != null) {
            this.virtualFurnaceAPI.disableAPI();
        }
        Board.clearBoards();
    }

    public static SkBee getPlugin() {
        return instance;
    }

    public Config getPluginConfig() {
        return this.config;
    }

    public BoundConfig getBoundConfig() {
        return this.boundConfig;
    }

    public BeeWorldConfig getBeeWorldConfig() {
        return this.beeWorldConfig;
    }

    public NBTApi getNbtApi() {
        return this.nbtApi;
    }

    public VirtualFurnaceAPI getVirtualFurnaceAPI() {
        return this.virtualFurnaceAPI;
    }

    static {
        ConfigurationSerialization.registerClass(Bound.class, (String)"Bound");
    }
}

