/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.recipe.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Event;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.KnowledgeBookMeta;
import tk.shanebee.bee.SkBee;

@Name(value="Recipe - Knowledge Book")
@Description(value={"Add/Remove custom or minecraft recipes to/from a knowledge book item.", "Optional string for plugin name, to add recipes from other plugins. Requires MC 1.13+"})
@Examples(value={"add custom recipe \"my_recipe\" to player's tool", "add minecraft recipe \"cooked_cod_from_campfire_cooking\" to {_book}"})
@Since(value="1.0.0")
public class EffKnowledgeBook
extends Effect {
    private Expression<String> recipes;
    private Expression<ItemType> book;
    private Expression<String> plugin;
    private boolean minecraft;
    private boolean add;

    public boolean init(Expression<?>[] exprs, int pattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.recipes = exprs[0];
        this.book = exprs[2];
        this.plugin = exprs[1];
        this.minecraft = parseResult.mark == 1;
        this.add = pattern != 1;
        return true;
    }

    protected void execute(Event event) {
        if (((ItemType)this.book.getSingle(event)).getMaterial() != Material.KNOWLEDGE_BOOK) {
            return;
        }
        ItemType book = (ItemType)this.book.getSingle(event);
        String pl = (String)this.plugin.getSingle(event);
        Object plugin = Bukkit.getPluginManager().getPlugin(pl);
        if (plugin == null) {
            plugin = SkBee.getPlugin();
        }
        String[] recipes = (String[])this.recipes.getAll(event);
        KnowledgeBookMeta meta = (KnowledgeBookMeta)book.getItemMeta();
        ArrayList<NamespacedKey> allRecipes = new ArrayList<NamespacedKey>(meta.getRecipes());
        for (String recipe : recipes) {
            NamespacedKey key = this.minecraft ? NamespacedKey.minecraft((String)recipe) : new NamespacedKey(plugin, recipe);
            if (this.add) {
                allRecipes.add(key);
                continue;
            }
            allRecipes.remove(key);
        }
        meta.setRecipes(allRecipes);
        book.setItemMeta((ItemMeta)meta);
    }

    public String toString(Event e, boolean d) {
        return (this.add ? "add" : "remove") + (this.minecraft ? " minecraft" : "custom") + " recipe(s) " + this.recipes.toString(e, d) + (this.add ? " to " : " from ") + this.book.toString(e, d);
    }

    static {
        Skript.registerEffect(EffKnowledgeBook.class, (String[])new String[]{"add [(custom|1\u00a6(mc|minecraft))] recipe[s] [with id[s]] %strings% [from plugin %-string%] to %itemtype%", "remove [(custom|1\u00a6(mc|minecraft))] recipe[s] [with id[s]] %strings% [from plugin %-string%] from %itemtype%"});
    }
}

