/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.other.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.event.server.TabCompleteEvent;
import org.jetbrains.annotations.NotNull;

@Name(value="Tab Completion Argument")
@Description(value={"Get the argument in a tab complete event."})
@Examples(value={"on tab complete of \"/breakfast\":", "\tset tab completions for position 1 to \"toast\", \"eggs\" and \"waffles\"", "\tif tab arg-1 = \"toast\":", "\t\tset tab completions for position 2 to \"butter\", \"peanut_butter\" and \"jam\"", "\telse if tab arg-1 = \"eggs\":", "\t\tset tab completions for position 2 to \"sunny_side_up\", \"scrambled\" and \"over_easy\""})
@Since(value="1.7.0")
public class ExprTabCompletionArgs
extends SimpleExpression<String> {
    private Expression<Number> position;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        if (!ScriptLoader.isCurrentEvent(TabCompleteEvent.class)) {
            Skript.error((String)"Tab completion arguments are only usable in a tab complete event.", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        this.position = exprs[0];
        return true;
    }

    @Nullable
    protected String[] get(@NotNull Event e) {
        int position;
        TabCompleteEvent event = (TabCompleteEvent)e;
        String buffer = event.getBuffer();
        String[] buffers = buffer.split(" ");
        if (buffers.length >= (position = ((Number)this.position.getSingle(e)).intValue()) + 1) {
            return new String[]{buffers[position]};
        }
        return new String[0];
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "tab complete arg-" + this.position.toString(e, d);
    }

    static {
        if (Skript.classExists((String)"org.bukkit.event.server.TabCompleteEvent")) {
            Skript.registerExpression(ExprTabCompletionArgs.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"tab [complete] arg[ument][(-| )]%number%"});
        }
    }
}

