/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Version;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

@Name(value="Block Cuboid")
@Description(value={"All the blocks within a cuboid located between 2 location points"})
@Examples(value={"set {_blocks::*} to all blocks within {_loc1} and {_loc2}", "set all blocks within {_loc1} and {_loc2} to stone", "loop all blocks within {_loc1} and {_loc2}:", "\tif loop-block is stone:", "\t\tset loop-block to grass"})
@Since(value="1.0.0")
public class ExprBlockCuboid
extends SimpleExpression<Block> {
    private Expression<Location> from;
    private Expression<Location> to;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.from = exprs[0];
        this.to = exprs[1];
        return true;
    }

    protected Block[] get(Event e) {
        Location to;
        Location from = this.from != null ? (Location)this.from.getSingle(e) : null;
        Location location = to = this.to != null ? (Location)this.to.getSingle(e) : null;
        if (to == null || from == null) {
            return null;
        }
        ArrayList<Block> list = new ArrayList<Block>(this.getBlocks(from, to));
        return list.toArray(new Block[0]);
    }

    public Class<? extends Block> getReturnType() {
        return Block.class;
    }

    public boolean isSingle() {
        return false;
    }

    public String toString(Event e, boolean d) {
        return "cuboid blocks within " + this.from.toString(e, d) + " and " + this.to.toString(e, d);
    }

    private List<Block> getBlocks(Location loc1, Location loc2) {
        int zMax;
        int zMin;
        int yMax;
        int yMin;
        int xMax;
        int xMin;
        World w = loc1.getWorld();
        ArrayList<Block> blocks = new ArrayList<Block>();
        int x1 = loc1.getBlockX();
        int y1 = loc1.getBlockY();
        int z1 = loc1.getBlockZ();
        int x2 = loc2.getBlockX();
        int y2 = loc2.getBlockY();
        int z2 = loc2.getBlockZ();
        if (x1 > x2) {
            xMin = x2;
            xMax = x1;
        } else {
            xMin = x1;
            xMax = x2;
        }
        if (y1 > y2) {
            yMin = y2;
            yMax = y1;
        } else {
            yMin = y1;
            yMax = y2;
        }
        if (z1 > z2) {
            zMin = z2;
            zMax = z1;
        } else {
            zMin = z1;
            zMax = z2;
        }
        for (int x = xMin; x <= xMax; ++x) {
            for (int y = yMin; y <= yMax; ++y) {
                for (int z = zMin; z <= zMax; ++z) {
                    Block b = new Location(w, (double)x, (double)y, (double)z).getBlock();
                    blocks.add(b);
                }
            }
        }
        return blocks;
    }

    static {
        if (Skript.getVersion().isSmallerThan(new Version(new int[]{2, 5, 1}))) {
            Skript.registerExpression(ExprBlockCuboid.class, Block.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[(all [[of] the]|the)] blocks within %location% and %location%"});
        }
    }
}

