/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.other.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tk.shanebee.bee.api.util.ParticleUtil;

@Name(value="Particle Spawn")
@Description(value={"Spawn a particle. This system is more inline with how Bukkit deals with particles, hence the amount of patterns.", "Some particles may be affected differently by these values, so let's break them down:", "\nfirst number = count, how many particles to spawn at once.", "\nparticle = the particle to spawn.", "\nusing = the data used for this particle (some particles like 'block', 'item' and 'dust' require more data).", "\nlocation = where you are going to spawn the particle.", "\noffset = a vector with the maximum random offset. The position of each particle will be randomized positively and negatively by the offset parameters on each axis.", "I believe some particles use the offset to set color. I'm not positive on this.", "\nextra = the extra data for this particle, depends on the particle used (normally speed).", "\nRequires Minecraft 1.13+"})
@Examples(value={"play 3 of item particle using diamond at location of player", "play 1 of block particle using dirt at location of target block", "play 10 of poof at player offset by vector(2, 2, 2) with extra 0.5", "play 20 of dust using dustOption(blue, 10) at location above target block"})
@Since(value="INSERT VERSION")
public class EffParticle
extends Effect {
    private int pattern;
    private Expression<Number> count;
    private Expression<Particle> particle;
    private Expression<Location> location;
    @Nullable
    private Expression<Vector> offset;
    private Expression<Number> extra;
    @Nullable
    private Expression<Object> data;
    @Nullable
    private Expression<Player> players;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.pattern = matchedPattern;
        this.count = exprs[0];
        this.particle = exprs[1];
        this.data = exprs[2];
        this.location = Direction.combine(exprs[3], exprs[4]);
        this.offset = this.pattern != 0 ? exprs[5] : null;
        this.extra = this.pattern == 2 ? exprs[6] : null;
        this.players = exprs[this.pattern + 5];
        return true;
    }

    protected void execute(@NotNull Event e) {
        if (this.count == null || this.particle == null || this.location == null) {
            return;
        }
        int count = ((Number)this.count.getSingle(e)).intValue();
        Particle particle = (Particle)this.particle.getSingle(e);
        Location[] locations = (Location[])this.location.getArray(e);
        Vector offset = this.offset != null ? (Vector)this.offset.getSingle(e) : null;
        double extra = this.extra != null ? ((Number)this.extra.getSingle(e)).doubleValue() : 0.0;
        Object data = this.data != null ? this.data.getSingle(e) : null;
        Player[] players = this.players != null ? (Player[])this.players.getArray(e) : null;
        block5: for (Location location : locations) {
            switch (this.pattern) {
                case 0: {
                    ParticleUtil.spawnParticle(players, particle, location, count, data);
                    continue block5;
                }
                case 1: {
                    ParticleUtil.spawnParticle(players, particle, location, count, offset, data);
                    continue block5;
                }
                case 2: {
                    ParticleUtil.spawnParticle(players, particle, location, count, offset, extra, data);
                }
            }
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String data = this.data != null ? "using " + this.data.toString(e, d) : "";
        String offset = this.offset != null ? "offset by " + this.offset.toString(e, d) : "";
        String extra = this.extra != null ? "with extra " + this.extra.toString(e, d) : "";
        String players = this.players != null ? "to " + this.players.toString(e, d) : "";
        return String.format("spawn %s of %s %s %s %s %s %s", this.count.toString(e, d), this.particle.toString(e, d), data, this.location.toString(e, d), offset, extra, players);
    }

    static {
        if (Skript.isRunningMinecraft((int)1, (int)13)) {
            Skript.registerEffect(EffParticle.class, (String[])new String[]{"(spawn|play) %number% [of] %particle% [particle] [using %-itemtype/blockdata/dustoption%] %directions% %locations% [(for|to) %-players%]", "(spawn|play) %number% [of] %particle% [particle] [using %-itemtype/blockdata/dustoption%] %directions% %locations% offset by %vector% [(for|to) %-players%]", "(spawn|play) %number% [of] %particle% [particle] [using %-itemtype/blockdata/dustoption%] %directions% %locations% offset by %vector% with extra %number% [(for|to) %-players%]"});
        }
    }
}

