/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.api.util;

import ch.njol.skript.aliases.ItemType;
import ch.njol.util.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;
import tk.shanebee.bee.api.reflection.ReflectionUtils;

public class ParticleUtil {
    private static final Map<String, Particle> PARTICLES = new HashMap<String, Particle>();

    public static String getNamesAsString() {
        ArrayList names = new ArrayList();
        PARTICLES.forEach((s, particle) -> {
            String name = s;
            if (particle.getDataType() != Void.class) {
                name = name + " [" + ParticleUtil.getDataType(particle) + "]";
            }
            names.add(name);
        });
        Collections.sort(names);
        return StringUtils.join(names, (String)", ");
    }

    public static String getName(Particle particle) {
        for (String key : PARTICLES.keySet()) {
            if (PARTICLES.get(key) != particle) continue;
            return key;
        }
        return null;
    }

    @Nullable
    public static Particle parse(String key) {
        if (PARTICLES.containsKey(key)) {
            return PARTICLES.get(key);
        }
        return null;
    }

    private static String getDataType(Particle particle) {
        Class t = particle.getDataType();
        if (t == ItemStack.class) {
            return "itemtype";
        }
        if (t == Particle.DustOptions.class) {
            return "dust-option";
        }
        if (t == BlockData.class) {
            return "blockdata/itemtype";
        }
        return "";
    }

    public static void spawnParticle(@Nullable Player[] players, Particle particle, Location location, int count, Vector offset, double extra, Object data) {
        if (offset == null) {
            return;
        }
        Object particleData = ParticleUtil.getData(particle, data);
        if (particle.getDataType() != Void.class && particleData == null) {
            return;
        }
        double x = offset.getX();
        double y = offset.getY();
        double z = offset.getZ();
        if (players == null) {
            World world = location.getWorld();
            if (world == null) {
                return;
            }
            world.spawnParticle(particle, location, count, x, y, z, extra, particleData);
        } else {
            for (Player player : players) {
                assert (player != null);
                player.spawnParticle(particle, location, count, x, y, z, extra, particleData);
            }
        }
    }

    public static void spawnParticle(@Nullable Player[] players, Particle particle, Location location, int count, Vector offset, Object data) {
        if (offset == null) {
            return;
        }
        Object particleData = ParticleUtil.getData(particle, data);
        if (particle.getDataType() != Void.class && particleData == null) {
            return;
        }
        double x = offset.getX();
        double y = offset.getY();
        double z = offset.getZ();
        if (players == null) {
            World world = location.getWorld();
            if (world == null) {
                return;
            }
            world.spawnParticle(particle, location, count, x, y, z, particleData);
        } else {
            for (Player player : players) {
                assert (player != null);
                player.spawnParticle(particle, location, count, x, y, z, particleData);
            }
        }
    }

    public static void spawnParticle(@Nullable Player[] players, Particle particle, Location location, int count, Object data) {
        Object particleData = ParticleUtil.getData(particle, data);
        if (particle.getDataType() != Void.class && particleData == null) {
            return;
        }
        if (players == null) {
            World world = location.getWorld();
            if (world == null) {
                return;
            }
            world.spawnParticle(particle, location, count, particleData);
        } else {
            for (Player player : players) {
                assert (player != null);
                player.spawnParticle(particle, location, count, particleData);
            }
        }
    }

    private static Object getData(Particle particle, Object data) {
        Class dataType = particle.getDataType();
        if (dataType == ItemStack.class && data instanceof ItemType) {
            return ((ItemType)data).getRandom();
        }
        if (dataType == Particle.DustOptions.class && data instanceof Particle.DustOptions) {
            return data;
        }
        if (dataType == BlockData.class) {
            Material material;
            if (data instanceof BlockData) {
                return data;
            }
            if (data instanceof ItemType && (material = ((ItemType)data).getMaterial()).isBlock()) {
                return material.createBlockData();
            }
        }
        return null;
    }

    static {
        Class<?> cbParticle = ReflectionUtils.getOBCClass("CraftParticle");
        Class<?> mcKey = ReflectionUtils.getNMSClass("MinecraftKey");
        try {
            assert (cbParticle != null);
            Field mc = cbParticle.getDeclaredField("minecraftKey");
            mc.setAccessible(true);
            Field pc = cbParticle.getDeclaredField("bukkit");
            pc.setAccessible(true);
            for (Object enumConstant : cbParticle.getEnumConstants()) {
                assert (mcKey != null);
                String KEY = mcKey.getMethod("getKey", new Class[0]).invoke(mc.get(enumConstant), new Object[0]).toString();
                Particle PARTICLE = (Particle)pc.get(enumConstant);
                if (PARTICLE.toString().contains("LEGACY")) continue;
                PARTICLES.put(KEY, PARTICLE);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

