/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.api.NBT;

import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import tk.shanebee.bee.SkBee;
import tk.shanebee.bee.api.NBT.NBTCompound;
import tk.shanebee.bee.api.NBT.NBTContainer;
import tk.shanebee.bee.api.NBT.NBTEntity;
import tk.shanebee.bee.api.NBTApi;

public class NBTCustomEntity
extends NBTEntity {
    private final Entity entity;
    private NBTCompound customNBT;
    private NamespacedKey KEY;

    public NBTCustomEntity(Entity entity) {
        super(entity);
        this.entity = entity;
        if (NBTApi.HAS_PERSISTENCE) {
            this.KEY = new NamespacedKey((Plugin)SkBee.getPlugin(), "custom-nbt");
            PersistentDataContainer container = entity.getPersistentDataContainer();
            String data = null;
            if (container.has(this.KEY, PersistentDataType.STRING)) {
                data = (String)container.get(this.KEY, PersistentDataType.STRING);
            }
            this.customNBT = new NBTContainer(data != null ? data : "{}");
        }
    }

    public NBTCompound getCustomNBT() {
        return this.customNBT;
    }

    public void setCustomNBT(NBTCompound customNBT) {
        this.customNBT = customNBT;
        PersistentDataContainer container = this.entity.getPersistentDataContainer();
        container.set(this.KEY, PersistentDataType.STRING, (Object)customNBT.toString());
    }

    public void deleteCustomNBT() {
        PersistentDataContainer container = this.entity.getPersistentDataContainer();
        if (container.has(this.KEY, PersistentDataType.STRING)) {
            container.remove(this.KEY);
        }
    }

    public NBTCompound getCustomNBTCompound() {
        NBTContainer compound = new NBTContainer(this.getCompound().toString());
        if (compound.hasKey("BukkitValues").booleanValue()) {
            NBTCompound persist = compound.getCompound("BukkitValues");
            persist.removeKey("skbee:custom-nbt");
            if (persist.getKeys().size() == 0) {
                compound.removeKey("BukkitValues");
            }
        }
        NBTCompound customCompound = compound.addCompound("custom");
        if (this.customNBT != null) {
            customCompound.mergeCompound(this.customNBT);
        }
        return compound;
    }

    @Override
    public String toString() {
        if (NBTApi.HAS_PERSISTENCE) {
            return this.getCustomNBTCompound().toString();
        }
        return super.toString();
    }
}

