/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.recipe.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import tk.shanebee.bee.SkBee;
import tk.shanebee.bee.config.Config;
import tk.shanebee.bee.elements.recipe.util.RecipeUtil;

@Name(value="Recipe - Remove")
@Description(value={"Remove a recipe from your server. Recipes can be removed at any time ", "but it is best to do so during a server load event. If a recipe is removed whilst a player is online ", "it will still show up in their recipe book, but they will not be able to craft it. If need be, you can get ", "a list of all recipes by simply typing \"/minecraft:recipe give YourName \" in game.", "You can remove Minecraft recipes, custom recipes and recipes from other plugins. Requires MC 1.13+"})
@Examples(value={"remove mc recipe \"acacia_boat\"", "remove minecraft recipe \"cooked_chicken_from_campfire_cooking\"", "remove recipe \"minecraft:diamond_sword\"", "remove all minecraft recipes", "remove custom recipe \"my_recipe\"", "remove recipe \"another_recipe\"", "remove recipe \"someplugin:some_recipe\""})
@Since(value="1.0.0")
public class EffRemoveRecipe
extends Effect {
    private final Config config = SkBee.getPlugin().getPluginConfig();
    private Expression<String> recipes;
    private boolean all;
    private boolean MC;

    public boolean init(Expression<?>[] exprs, int pattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.all = pattern == 1;
        this.MC = this.all || parseResult.mark == 1;
        this.recipes = pattern == 0 ? exprs[0] : null;
        return true;
    }

    protected void execute(Event event) {
        if (this.all) {
            RecipeUtil.removeAllMCRecipes();
            if (this.config.SETTINGS_DEBUG) {
                RecipeUtil.log("&aRemoving all Minecraft recipes.");
            }
            return;
        }
        String[] recipes = (String[])this.recipes.getAll(event);
        if (recipes == null) {
            return;
        }
        for (String recipe : recipes) {
            if (this.MC || recipe.startsWith("minecraft:")) {
                recipe = recipe.replace("minecraft:", "");
                if (this.config.SETTINGS_DEBUG) {
                    RecipeUtil.log("&aRemoving recipe: minecraft:" + recipe);
                }
                RecipeUtil.removeMCRecipe(recipe);
                continue;
            }
            if (this.config.SETTINGS_DEBUG) {
                RecipeUtil.log("&aRemoving recipe: " + recipe);
            }
            RecipeUtil.removeRecipeByKey(recipe);
        }
    }

    public String toString(Event e, boolean d) {
        if (this.all) {
            return "remove all minecraft recipes";
        }
        if (this.MC) {
            return "remove minecraft recipes " + this.recipes.toString(e, d);
        }
        return "remove custom recipes " + this.recipes.toString(e, d);
    }

    static {
        Skript.registerEffect(EffRemoveRecipe.class, (String[])new String[]{"remove [(0\u00a6custom|1\u00a6(mc|minecraft))] recipe[s] %strings%", "remove all (mc|minecraft) recipe[s]"});
    }
}

