/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.api.virtualfurnace.api.machine;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import tk.shanebee.bee.api.virtualfurnace.api.RecipeManager;
import tk.shanebee.bee.api.virtualfurnace.api.VirtualFurnaceAPI;
import tk.shanebee.bee.api.virtualfurnace.api.event.machine.FurnaceCookEvent;
import tk.shanebee.bee.api.virtualfurnace.api.event.machine.FurnaceFuelBurnEvent;
import tk.shanebee.bee.api.virtualfurnace.api.machine.Machine;
import tk.shanebee.bee.api.virtualfurnace.api.property.FurnaceProperties;
import tk.shanebee.bee.api.virtualfurnace.api.property.PropertyHolder;
import tk.shanebee.bee.api.virtualfurnace.api.recipe.Fuel;
import tk.shanebee.bee.api.virtualfurnace.api.recipe.FurnaceRecipe;
import tk.shanebee.bee.api.virtualfurnace.api.util.Util;

public class Furnace
extends Machine
implements PropertyHolder<FurnaceProperties>,
InventoryHolder,
ConfigurationSerializable {
    private final FurnaceProperties furnaceProperties;
    private final RecipeManager recipeManager;
    private ItemStack fuel;
    private ItemStack input;
    private ItemStack output;
    private int cookTime;
    private int cookTimeTotal;
    private int fuelTime;
    private int fuelTimeTotal;
    private final Inventory inventory;
    private float experience;

    public Furnace(String name) {
        this(name, FurnaceProperties.FURNACE);
    }

    public Furnace(String name, FurnaceProperties furnaceProperties) {
        super(UUID.randomUUID(), name);
        this.furnaceProperties = furnaceProperties;
        this.recipeManager = VirtualFurnaceAPI.getInstance().getRecipeManager();
        this.cookTime = 0;
        this.cookTimeTotal = 0;
        this.fuelTime = 0;
        this.fuelTimeTotal = 0;
        this.fuel = null;
        this.input = null;
        this.output = null;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (InventoryType)InventoryType.FURNACE, (String)Util.getColString(name));
        this.experience = 0.0f;
        this.updateInventory();
    }

    private Furnace(String name, UUID uuid, int cookTime, int fuelTime, float xp, ItemStack fuel, ItemStack input, ItemStack output, FurnaceProperties furnaceProperties) {
        super(uuid, name);
        this.recipeManager = VirtualFurnaceAPI.getInstance().getRecipeManager();
        this.cookTime = cookTime;
        this.fuelTime = fuelTime;
        this.fuel = fuel;
        this.input = input;
        this.output = output;
        this.furnaceProperties = furnaceProperties;
        FurnaceRecipe furnaceRecipe = this.recipeManager.getByIngredient(input != null ? input.getType() : null);
        this.cookTimeTotal = furnaceRecipe != null ? furnaceRecipe.getCookTime() : 0;
        Fuel fuelF = this.recipeManager.getFuelByMaterial(fuel != null ? fuel.getType() : null);
        this.fuelTimeTotal = fuelF != null ? fuelF.getBurnTime() : 0;
        this.experience = xp;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (InventoryType)InventoryType.FURNACE, (String)Util.getColString(name));
        this.updateInventory();
    }

    @Override
    public FurnaceProperties getProperties() {
        return this.furnaceProperties;
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public ItemStack getFuel() {
        return this.fuel;
    }

    public void setFuel(ItemStack fuel) {
        this.fuel = fuel;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public void setInput(ItemStack input) {
        this.input = input;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public float extractExperience() {
        float exp = this.experience;
        this.experience = 0.0f;
        return exp;
    }

    @Override
    public void openInventory(Player player) {
        this.updateInventory();
        player.openInventory(this.inventory);
    }

    private void updateInventory() {
        this.inventory.setItem(0, this.input);
        this.inventory.setItem(1, this.fuel);
        this.inventory.setItem(2, this.output);
    }

    private void updateInventoryView() {
        ItemStack output;
        ItemStack fuel;
        ItemStack input = this.inventory.getItem(0);
        if (this.input != input) {
            this.input = input;
        }
        if (this.fuel != (fuel = this.inventory.getItem(1))) {
            this.fuel = fuel;
        }
        if (this.output != (output = this.inventory.getItem(2))) {
            this.output = output;
        }
        for (HumanEntity entity : this.inventory.getViewers()) {
            InventoryView view = entity.getOpenInventory();
            view.setProperty(InventoryView.Property.COOK_TIME, this.cookTime);
            view.setProperty(InventoryView.Property.TICKS_FOR_CURRENT_SMELTING, this.cookTimeTotal);
            view.setProperty(InventoryView.Property.BURN_TIME, this.fuelTime);
            view.setProperty(InventoryView.Property.TICKS_FOR_CURRENT_FUEL, this.fuelTimeTotal);
        }
    }

    @Override
    public void tick() {
        if (this.fuelTime > 0) {
            --this.fuelTime;
            if (this.canCook()) {
                ++this.cookTime;
                if (this.cookTime >= this.cookTimeTotal) {
                    this.cookTime = 0;
                    this.processCook();
                }
            } else {
                this.cookTime = 0;
            }
        } else if (this.canBurn() && this.canCook()) {
            this.processBurn();
        } else if (this.cookTime > 0) {
            this.cookTime = this.canCook() ? (this.cookTime -= 5) : 0;
        }
        this.updateInventoryView();
    }

    private boolean canBurn() {
        if (this.fuel == null) {
            return false;
        }
        return this.recipeManager.getFuelByMaterial(this.fuel.getType()) != null;
    }

    private void processBurn() {
        int burn;
        Fuel fuel = this.recipeManager.getFuelByMaterial(this.fuel.getType());
        if (fuel == null) {
            return;
        }
        FurnaceFuelBurnEvent event = new FurnaceFuelBurnEvent(this, this.fuel, fuel, fuel.getBurnTime());
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        int fuelAmount = this.fuel.getAmount();
        if (fuelAmount > 1) {
            this.fuel.setAmount(fuelAmount - 1);
        } else {
            this.fuel = null;
        }
        this.fuelTime = burn = (int)((double)event.getBurnTime() / this.furnaceProperties.getFuelMultiplier());
        this.fuelTimeTotal = burn;
        this.updateInventory();
    }

    private boolean canCook() {
        if (this.input == null) {
            return false;
        }
        FurnaceRecipe result = this.recipeManager.getByIngredient(this.input.getType());
        if (result == null) {
            return false;
        }
        this.cookTimeTotal = (int)((double)result.getCookTime() / this.furnaceProperties.getCookMultiplier());
        if (this.output == null) {
            return true;
        }
        Material type = this.output.getType();
        if (type == result.getResultType()) {
            return this.output.getAmount() < type.getMaxStackSize();
        }
        return false;
    }

    private void processCook() {
        ItemStack out;
        FurnaceRecipe result = this.recipeManager.getByIngredient(this.input.getType());
        if (result == null) {
            return;
        }
        if (this.output == null) {
            out = new ItemStack(result.getResultType());
        } else {
            out = this.output.clone();
            out.setAmount(out.getAmount() + 1);
        }
        this.experience += result.getExperience();
        FurnaceCookEvent event = new FurnaceCookEvent(this, this.input, out);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.output = event.getResult();
        int inputAmount = this.input.getAmount();
        if (inputAmount > 1) {
            this.input.setAmount(inputAmount - 1);
        } else {
            this.input = null;
        }
        this.updateInventory();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Furnace furnace = (Furnace)o;
        return this.cookTime == furnace.cookTime && this.cookTimeTotal == furnace.cookTimeTotal && this.fuelTime == furnace.fuelTime && this.fuelTimeTotal == furnace.fuelTimeTotal && Objects.equals(this.furnaceProperties, furnace.furnaceProperties) && Objects.equals(this.recipeManager, furnace.recipeManager) && Objects.equals(this.fuel, furnace.fuel) && Objects.equals(this.input, furnace.input) && Objects.equals(this.output, furnace.output) && Objects.equals(this.inventory, furnace.inventory);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.furnaceProperties, this.recipeManager, this.fuel, this.input, this.output, this.cookTime, this.cookTimeTotal, this.fuelTime, this.fuelTimeTotal, this.inventory);
    }

    @Override
    public String toString() {
        return "Furnace{name='" + this.getName() + '\'' + ", uuid=" + this.getUniqueID() + ", properties=" + this.furnaceProperties + ", fuel=" + this.fuel + ", input=" + this.input + ", output=" + this.output + ", cookTime=" + this.cookTime + ", fuelTime=" + this.fuelTime + '}';
    }

    @NotNull
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("name", this.getName());
        result.put("uuid", this.getUniqueID().toString());
        result.put("properties", this.furnaceProperties);
        result.put("cookTime", this.cookTime);
        result.put("fuelTime", this.fuelTime);
        result.put("xp", Float.valueOf(this.experience));
        result.put("fuel", this.fuel);
        result.put("input", this.input);
        result.put("output", this.output);
        return result;
    }

    public static Furnace deserialize(Map<String, Object> args) {
        String name = (String)args.get("name");
        UUID uuid = UUID.fromString((String)args.get("uuid"));
        FurnaceProperties furnaceProperties = (FurnaceProperties)args.get("properties");
        int cookTime = ((Number)args.get("cookTime")).intValue();
        int fuelTime = ((Number)args.get("fuelTime")).intValue();
        float xp = args.containsKey("xp") ? ((Number)args.get("xp")).floatValue() : 0.0f;
        ItemStack fuel = (ItemStack)args.get("fuel");
        ItemStack input = (ItemStack)args.get("input");
        ItemStack output = (ItemStack)args.get("output");
        return new Furnace(name, uuid, cookTime, fuelTime, xp, fuel, input, output, furnaceProperties);
    }
}

