/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.api.Structure.core.entity;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import tk.shanebee.bee.api.Structure.api.entity.Position;
import tk.shanebee.bee.api.Structure.api.entity.ProgressToken;
import tk.shanebee.bee.api.Structure.api.entity.StructureLoaderAbstract;
import tk.shanebee.bee.api.Structure.api.entity.StructureSaverAbstract;
import tk.shanebee.bee.api.Structure.api.enumeration.StructureMirror;
import tk.shanebee.bee.api.Structure.api.enumeration.StructureRotation;
import tk.shanebee.bee.api.Structure.api.enumeration.Version;
import tk.shanebee.bee.api.Structure.api.service.ProxyService;
import tk.shanebee.bee.api.Structure.api.service.StructureSerializationService;
import tk.shanebee.bee.api.Structure.api.service.StructureWorldService;
import tk.shanebee.bee.api.Structure.core.entity.ProgressTokenImpl;
import tk.shanebee.bee.api.Structure.core.entity.StructurePlaceMetaImpl;
import tk.shanebee.bee.api.Structure.lib.org.jetbrains.annotations.NotNull;
import tk.shanebee.bee.api.Structure.lib.org.jetbrains.annotations.Nullable;

public class StructureLoaderAbstractImpl<L, V>
implements StructureLoaderAbstract<L, V> {
    private final ProxyService proxyService;
    private final StructureSerializationService serializationService;
    private final StructureWorldService worldService;
    private Position location;
    private boolean includeEntities = false;
    private StructureRotation rotation = StructureRotation.NONE;
    private StructureMirror mirror = StructureMirror.NONE;
    private float integrity = 1.0f;
    private long seed = 0L;

    public StructureLoaderAbstractImpl(ProxyService proxyService, StructureSerializationService serializationService, StructureWorldService worldService) {
        this.proxyService = proxyService;
        this.serializationService = serializationService;
        this.worldService = worldService;
    }

    @Override
    @Nullable
    public L getLocation() {
        if (this.location == null) {
            return null;
        }
        return this.proxyService.toLocation(this.location);
    }

    @Override
    public boolean isIncludeEntitiesEnabled() {
        return this.includeEntities;
    }

    @Override
    public StructureMirror getMirrorType() {
        return this.mirror;
    }

    @Override
    public StructureRotation getRotationType() {
        return this.rotation;
    }

    @Override
    public float getIntegrity() {
        return this.integrity;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    @NotNull
    public StructureLoaderAbstract<L, V> at(@Nullable L location) {
        this.location = this.proxyService.toPosition(location);
        return this;
    }

    @Override
    public StructureLoaderAbstract<L, V> includeEntities(boolean enabled) {
        this.includeEntities = enabled;
        return this;
    }

    @Override
    public StructureLoaderAbstract<L, V> mirror(StructureMirror mirror) {
        this.mirror = mirror;
        return this;
    }

    @Override
    public StructureLoaderAbstract<L, V> rotation(StructureRotation rotation) {
        this.rotation = rotation;
        return this;
    }

    @Override
    public StructureLoaderAbstract<L, V> integrity(float integrity) {
        this.integrity = integrity;
        return this;
    }

    @Override
    public StructureLoaderAbstract<L, V> seed(long seed) {
        this.seed = seed;
        return this;
    }

    @Override
    @NotNull
    public ProgressToken<Void> loadFromSaver(@NotNull StructureSaverAbstract<L, V> source) {
        CompletableFuture completableFuture = new CompletableFuture();
        ProgressTokenImpl<Void> rootToken = new ProgressTokenImpl<Void>(completableFuture);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ProgressToken<Void> innerToken = source.saveToOutputStream(outputStream);
        rootToken.progress(0.0);
        innerToken.getCompletionStage().thenAccept(e_ -> {
            rootToken.progress(0.5);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            ProgressToken<Void> finalToken = this.loadFromInputStream(inputStream);
            finalToken.getCompletionStage().exceptionally(e -> {
                completableFuture.completeExceptionally((Throwable)e);
                return null;
            });
            finalToken.getCompletionStage().thenAccept(a_ -> {
                try {
                    outputStream.close();
                    inputStream.close();
                    rootToken.progress(1.0);
                    completableFuture.complete(a_);
                }
                catch (IOException ioException) {
                    completableFuture.completeExceptionally(ioException);
                }
            });
        });
        innerToken.getCompletionStage().exceptionally(e -> {
            completableFuture.completeExceptionally((Throwable)e);
            return null;
        });
        return rootToken;
    }

    @Override
    @NotNull
    public ProgressToken<Void> loadFromWorld(@NotNull String worldName, @NotNull String author, @NotNull String name) {
        Version version = this.proxyService.getServerVersion();
        File file = version.isVersionSameOrGreaterThan(Version.VERSION_1_13_R2) ? new File(worldName + File.separator + "generated" + File.separator + author + File.separator + "structures" + File.separator + name + ".nbt") : new File(worldName + File.separator + "structures" + File.separator + name + ".nbt");
        try {
            Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.loadFromFile(file);
    }

    @Override
    @NotNull
    public ProgressToken<Void> loadFromString(@NotNull String source) {
        CompletableFuture completableFuture = new CompletableFuture();
        ProgressTokenImpl<Void> rootToken = new ProgressTokenImpl<Void>(completableFuture);
        byte[] content = Base64.getDecoder().decode(source);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(content);
        ProgressToken<Void> innerToken = this.loadFromInputStream(byteArrayInputStream);
        innerToken.onProgress(rootToken::progress);
        innerToken.getCompletionStage().thenAccept(e -> {
            try {
                byteArrayInputStream.close();
                completableFuture.complete(e);
            }
            catch (IOException ioException) {
                completableFuture.completeExceptionally(ioException);
            }
        });
        innerToken.getCompletionStage().exceptionally(e -> {
            completableFuture.completeExceptionally((Throwable)e);
            return null;
        });
        return rootToken;
    }

    @Override
    @NotNull
    public ProgressToken<Void> loadFromPath(@NotNull Path source) {
        return this.loadFromFile(source.toFile());
    }

    @Override
    @NotNull
    public ProgressToken<Void> loadFromFile(@NotNull File source) {
        CompletableFuture completableFuture = new CompletableFuture();
        ProgressTokenImpl<Void> rootToken = new ProgressTokenImpl<Void>(completableFuture);
        this.proxyService.runAsyncTask(() -> {
            try {
                FileInputStream inputStream = new FileInputStream(source);
                ProgressToken<Void> progressToken = this.loadFromInputStream(inputStream);
                progressToken.onProgress(rootToken::progress);
                progressToken.getCompletionStage().thenAccept(c -> {
                    try {
                        inputStream.close();
                        completableFuture.complete(c);
                    }
                    catch (IOException e) {
                        completableFuture.completeExceptionally(e);
                    }
                });
                progressToken.getCompletionStage().exceptionally(throwable -> {
                    completableFuture.completeExceptionally((Throwable)throwable);
                    return null;
                });
            }
            catch (IOException e) {
                this.proxyService.runSyncTask(() -> completableFuture.completeExceptionally(e));
            }
        });
        return rootToken;
    }

    @Override
    @NotNull
    public ProgressToken<Void> loadFromInputStream(@NotNull InputStream source) {
        CompletableFuture completableFuture = new CompletableFuture();
        ProgressTokenImpl<Void> progressToken = new ProgressTokenImpl<Void>(completableFuture);
        StructurePlaceMetaImpl meta = new StructurePlaceMetaImpl();
        meta.location = this.location;
        meta.includeEntities = this.includeEntities;
        meta.integrity = this.integrity;
        meta.seed = this.seed;
        meta.mirror = this.mirror;
        meta.rotation = this.rotation;
        progressToken.progress(0.0);
        this.proxyService.runAsyncTask(() -> {
            try {
                Object definedStructure = this.serializationService.deSerialize(source);
                this.proxyService.runSyncTask(() -> {
                    progressToken.progress(0.5);
                    try {
                        this.worldService.placeStructureToWorld(meta, definedStructure);
                        completableFuture.complete(null);
                        progressToken.progress(1.0);
                    }
                    catch (Exception e) {
                        completableFuture.completeExceptionally(e);
                    }
                });
            }
            catch (IOException e) {
                this.proxyService.runSyncTask(() -> completableFuture.completeExceptionally(e));
            }
        });
        return progressToken;
    }
}

