/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.api.Structure.bukkit.v1_10_R1;

import net.minecraft.server.v1_10_R1.EnumBlockMirror;
import net.minecraft.server.v1_10_R1.EnumBlockRotation;
import net.minecraft.server.v1_10_R1.NBTTagCompound;
import net.minecraft.server.v1_10_R1.TileEntityStructure;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_10_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_10_R1.block.CraftBlockState;
import org.bukkit.util.Vector;
import tk.shanebee.bee.api.Structure.api.bukkit.block.StructureBlockData;
import tk.shanebee.bee.api.Structure.api.bukkit.block.StructureBlockLoad;
import tk.shanebee.bee.api.Structure.api.bukkit.block.StructureBlockSave;
import tk.shanebee.bee.api.Structure.api.entity.StructureLoaderAbstract;
import tk.shanebee.bee.api.Structure.api.entity.StructureSaverAbstract;
import tk.shanebee.bee.api.Structure.api.enumeration.StructureMirror;
import tk.shanebee.bee.api.Structure.api.enumeration.StructureMode;
import tk.shanebee.bee.api.Structure.api.enumeration.StructureRotation;
import tk.shanebee.bee.api.Structure.api.service.TypeConversionService;
import tk.shanebee.bee.api.Structure.core.block.StructureBlockAbstractImpl;
import tk.shanebee.bee.api.Structure.lib.org.jetbrains.annotations.NotNull;
import tk.shanebee.bee.api.Structure.lib.org.jetbrains.annotations.Nullable;

public class CraftStructureBlock
extends CraftBlockState
implements StructureBlockData,
StructureBlockSave,
StructureBlockLoad {
    public StructureBlockAbstractImpl<Location, Vector> internalBlock;
    public TypeConversionService conversionService;
    public TileEntityStructure tileEntityStructure;

    public CraftStructureBlock(StructureBlockAbstractImpl<Location, Vector> structure, TypeConversionService conversionService, Block block) {
        super(block);
        CraftWorld world = (CraftWorld)block.getWorld();
        this.internalBlock = structure;
        this.conversionService = conversionService;
        this.tileEntityStructure = (TileEntityStructure)world.getTileEntityAt(this.getX(), this.getY(), this.getZ());
        if (this.tileEntityStructure == null) {
            throw new IllegalArgumentException("The block at " + world.getName() + " " + this.getX() + " " + this.getY() + " " + this.getZ() + " is not a StructureBlock.");
        }
        NBTTagCompound compound = new NBTTagCompound();
        compound = this.tileEntityStructure.save(compound);
        this.setSaveName(compound.getString("name"));
        this.setAuthor(compound.getString("author"));
        this.setBlockNameMetaData(compound.getString("metadata"));
        this.setStructureLocation(new Location(block.getWorld(), (double)compound.getInt("posX"), (double)compound.getInt("posY"), (double)compound.getInt("posZ")));
        this.setSizeX(compound.getInt("sizeX"));
        this.setSizeY(compound.getInt("sizeY"));
        this.setSizeZ(compound.getInt("sizeZ"));
        this.setIncludeEntities(!compound.getBoolean("ignoreEntities"));
        this.setBoundingBoxVisible(compound.getBoolean("showboundingbox"));
        this.setInvisibleBlocksEnabled(compound.getBoolean("showair"));
        this.setIntegrity(compound.getFloat("integrity"));
        this.setSeed(compound.getLong("seed"));
        this.setMirrorType(conversionService.convertToStructureMirror(EnumBlockMirror.valueOf((String)compound.getString("mirror"))));
        this.setRotationType(conversionService.convertToStructureRotation(EnumBlockRotation.valueOf((String)compound.getString("rotation"))));
        this.setStructureMode(conversionService.convertToStructureMode(TileEntityStructure.UsageMode.valueOf((String)compound.getString("mode"))));
    }

    public boolean update(boolean force, boolean applyPhysics) {
        boolean result = super.update(force, applyPhysics);
        NBTTagCompound compound = new NBTTagCompound();
        compound = this.tileEntityStructure.save(compound);
        compound.setString("name", this.getSaveName());
        compound.setString("author", this.getAuthor());
        compound.setString("metadata", this.getBlockNameMetaData());
        compound.setInt("posX", this.getStructureLocation().getBlockX());
        compound.setInt("posY", this.getStructureLocation().getBlockY());
        compound.setInt("posZ", this.getStructureLocation().getBlockZ());
        compound.setInt("sizeX", this.getSizeX());
        compound.setInt("sizeY", this.getSizeY());
        compound.setInt("sizeZ", this.getSizeZ());
        compound.setBoolean("showboundingbox", this.isBoundingBoxVisible());
        compound.setBoolean("showair", this.isInvisibleBlocksEnabled());
        compound.setBoolean("ignoreEntities", !this.isIncludeEntitiesEnabled());
        compound.setFloat("integrity", this.getIntegrity());
        compound.setLong("seed", this.getSeed());
        compound.setString("rotation", this.conversionService.convertToRotationHandle(this.getRotationType()).toString());
        compound.setString("mirror", this.conversionService.convertToMirrorHandle(this.getMirrorType()).toString());
        compound.setString("mode", this.conversionService.convertToStructureModeHandle(this.getStructureMode()).toString());
        this.tileEntityStructure.a(compound);
        this.tileEntityStructure.update();
        return result;
    }

    @Override
    public void setMirrorType(@NotNull StructureMirror mirrorType) {
        this.internalBlock.setMirrorType(mirrorType);
    }

    @Override
    public void setRotationType(@NotNull StructureRotation rotation) {
        this.internalBlock.setRotationType(rotation);
    }

    @Override
    @NotNull
    public StructureRotation getRotationType() {
        return this.internalBlock.getRotationType();
    }

    @Override
    @NotNull
    public StructureMirror getMirrorType() {
        return this.internalBlock.getMirrorType();
    }

    @Override
    public void setBoundingBoxVisible(boolean visible) {
        this.internalBlock.setBoundingBoxVisible(visible);
    }

    @Override
    public boolean isBoundingBoxVisible() {
        return this.internalBlock.isBoundingBoxVisible();
    }

    @Override
    public void setIntegrity(float integrity) {
        this.internalBlock.setIntegrity(integrity);
    }

    @Override
    public float getIntegrity() {
        return this.internalBlock.getIntegrity();
    }

    @Override
    public void setSeed(long seed) {
        this.internalBlock.setSeed(seed);
    }

    @Override
    public long getSeed() {
        return this.internalBlock.getSeed();
    }

    @Override
    public void setAuthor(@Nullable String author) {
        this.internalBlock.setAuthor(author);
    }

    @Override
    @Nullable
    public String getAuthor() {
        return this.internalBlock.getAuthor();
    }

    @Override
    public void setStructureLocation(@Nullable Location location) {
        this.internalBlock.setStructureLocation(location);
    }

    @Override
    @Nullable
    public Location getStructureLocation() {
        return this.internalBlock.getStructureLocation();
    }

    @Override
    public void setIncludeEntities(boolean flag) {
        this.internalBlock.setIncludeEntities(flag);
    }

    @Override
    public boolean isIncludeEntitiesEnabled() {
        return this.internalBlock.isIncludeEntitiesEnabled();
    }

    @Override
    public void setSizeX(int sizeX) {
        this.internalBlock.setSizeX(sizeX);
    }

    @Override
    public void setSizeY(int sizeY) {
        this.internalBlock.setSizeY(sizeY);
    }

    @Override
    public void setSizeZ(int sizeZ) {
        this.internalBlock.setSizeZ(sizeZ);
    }

    @Override
    public int getSizeX() {
        return this.internalBlock.getSizeX();
    }

    @Override
    public int getSizeY() {
        return this.internalBlock.getSizeY();
    }

    @Override
    public int getSizeZ() {
        return this.internalBlock.getSizeZ();
    }

    @Override
    public void setSaveName(@Nullable String name) {
        this.internalBlock.setSaveName(name);
    }

    @Override
    @Nullable
    public String getSaveName() {
        return this.internalBlock.getSaveName();
    }

    @Override
    public void setBlockNameMetaData(@Nullable String blockNameMetaData) {
        this.internalBlock.setBlockNameMetaData(blockNameMetaData);
    }

    @Override
    @Nullable
    public String getBlockNameMetaData() {
        return this.internalBlock.getBlockNameMetaData();
    }

    @Override
    public void setInvisibleBlocksEnabled(boolean flag) {
        this.internalBlock.setInvisibleBlocksEnabled(flag);
    }

    @Override
    public boolean isInvisibleBlocksEnabled() {
        return this.internalBlock.isInvisibleBlocksEnabled();
    }

    @Override
    public void setStructureMode(@NotNull StructureMode structureMode) {
        this.internalBlock.setStructureMode(structureMode);
    }

    @Override
    @NotNull
    public StructureMode getStructureMode() {
        return this.internalBlock.getStructureMode();
    }

    @Override
    @NotNull
    public StructureLoaderAbstract<Location, Vector> loadStructure() {
        return this.internalBlock.loadStructure();
    }

    @Override
    @NotNull
    public StructureSaverAbstract<Location, Vector> saveStructure() {
        return this.internalBlock.saveStructure();
    }
}

