/*
 * Decompiled with CFR 0.152.
 */
package tk.shanebee.bee.elements.structure.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.io.File;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import tk.shanebee.bee.SkBee;
import tk.shanebee.bee.api.Structure.api.bukkit.StructureBlockLibApi;
import tk.shanebee.bee.api.Structure.api.enumeration.StructureMirror;
import tk.shanebee.bee.api.Structure.api.enumeration.StructureRotation;

@Name(value="Structure Block - Load")
@Description(value={"Load structure block structures that are saved on your server. Optional values for rotation, mirroring and the inclusion of entities. 1.9.4+ ONLY"})
@Examples(value={"load \"house\" at location of player", "load \"barn\" at location 10 infront of player", "paste \"house\" at location of player with rotation 90 and with mirror left to right", "load \"sheep_pen\" at location below player with rotation 180 and with entities"})
@Since(value="1.0.0")
public class EffLoadStructure
extends Effect {
    private static final String WORLD;
    private static final StructureBlockLibApi STRUCTURE_API;
    private Expression<String> name;
    private Expression<Location> loc;
    private int rotate = 0;
    private int mirror;
    private boolean withEntities;

    public boolean init(Expression<?> @NotNull [] exprs, int i, @NotNull Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.name = exprs[0];
        this.loc = exprs[1];
        this.rotate = parseResult.mark;
        this.mirror = i;
        this.withEntities = this.rotate == 5 || this.rotate == 4 || this.rotate == 7 || this.rotate == 6;
        return true;
    }

    protected void execute(@NotNull Event event) {
        StructureMirror mirror;
        StructureRotation rotation;
        switch (this.rotate) {
            case 1: 
            case 4: {
                rotation = StructureRotation.ROTATION_90;
                break;
            }
            case 2: 
            case 7: {
                rotation = StructureRotation.ROTATION_180;
                break;
            }
            case 3: 
            case 6: {
                rotation = StructureRotation.ROTATION_270;
                break;
            }
            default: {
                rotation = StructureRotation.NONE;
            }
        }
        switch (this.mirror) {
            case 1: {
                mirror = StructureMirror.FRONT_BACK;
                break;
            }
            case 2: {
                mirror = StructureMirror.LEFT_RIGHT;
                break;
            }
            default: {
                mirror = StructureMirror.NONE;
            }
        }
        boolean debug = SkBee.getPlugin().getPluginConfig().SETTINGS_DEBUG;
        Location location = (Location)this.loc.getSingle(event);
        if (location == null) {
            if (debug) {
                Skript.error((String)("Could not load structure " + this.name.toString(event, true) + " .. location does not exist: " + this.loc.toString(event, true)));
            }
            return;
        }
        String name = (String)this.name.getSingle(event);
        STRUCTURE_API.loadStructure((Plugin)SkBee.getPlugin()).at(location).rotation(rotation).mirror(mirror).includeEntities(this.withEntities).loadFromWorld(WORLD, "minecraft", name).onException(e -> {
            Skript.error((String)("Structure " + this.name.toString(event, true) + " does not exist!"));
            if (debug) {
                e.printStackTrace();
            }
        });
    }

    @NotNull
    public String toString(Event e, boolean d) {
        return "load structure " + this.name.toString(e, d) + " at " + this.loc.toString(e, d);
    }

    static {
        STRUCTURE_API = StructureBlockLibApi.INSTANCE;
        String worldContainer = Bukkit.getWorldContainer().getPath();
        WORLD = worldContainer.equalsIgnoreCase(".") ? ((World)Bukkit.getServer().getWorlds().get(0)).getName() : worldContainer + File.separator + ((World)Bukkit.getServer().getWorlds().get(0)).getName();
        Skript.registerEffect(EffLoadStructure.class, (String[])new String[]{"(load|paste) [structure] %string% at %location% [with rotation (0\u00a60|1\u00a690|2\u00a6180|3\u00a6270)] [(|5\u00a6[and] with entities)]", "(load|paste) [structure] %string% at %location% [with rotation (0\u00a60|1\u00a690|2\u00a6180|3\u00a6270)] [and] [with] mirror front to back [(|5\u00a6[and] with entities)]", "(load|paste) [structure] %string% at %location% [with rotation (0\u00a60|1\u00a690|2\u00a6180|3\u00a6270)] [and] [with] mirror left to right [(|5\u00a6[and] with entities)]"});
    }
}

